/*******************************************************************************
*
 * Copyright (c) 2013 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
* 
*
****************************************************************************//*!
*
* @brief  Definition file for sine and cosine functions
* 
*******************************************************************************/
#ifndef _GFLIB_SINCOS_F32_DEFASM_H_
#define _GFLIB_SINCOS_F32_DEFASM_H_

#if defined(__cplusplus) 
extern "C" { 
#endif 
/******************************************************************************
* Includes
******************************************************************************/
#include "GFLIB_SinCos_F32_Asm.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_Sin_F16_Asm(f16Angle) GFLIB_Sin_F16_FAsm(f16Angle, &gsSinCoefTable_F32)
#define GFLIB_Cos_F16_Asm(f16Angle) GFLIB_Cos_F16_FAsmi(f16Angle, &gsSinCoefTable_F32)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global constants
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/
extern GFLIB_CONST GFLIB_SIN_T_F32 gsSinCoefTable_F32;

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
* Inline functions
******************************************************************************/
#if defined(__cplusplus) 
} 
#endif 

#endif /* _GFLIB_SINCOS_F32_DEFASM_H_ */
