/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* File Name:  dma.c
*
* Description: Source file for the DMA Driver
*
*****************************************************************************/

#include "qs.h"
#include "dma.h"
#include "initconfig.h"


#ifdef __cplusplus
extern "C" {
#endif

/* initialization of DMA  */

void Dma_init(void)
{
    Dma_common_init(EDMA);


    #if EDMA_CHANNEL_0_INIT_USED
    #ifdef EDMA_MUX_CHCFG0_INIT
    periphMemWrite(0, &(DMA_MUX->chcfg[0]));
    #endif
    Dma_channel_init(EDMA_0);
    #ifdef EDMA_MUX_CHCFG0_INIT
    periphMemWrite(EDMA_MUX_CHCFG0_INIT, &(DMA_MUX->chcfg[0]));
    #endif
    #endif
    #if EDMA_CHANNEL_1_INIT_USED
    #ifdef EDMA_MUX_CHCFG1_INIT
    periphMemWrite(0, &(DMA_MUX->chcfg[1]));
    #endif
    Dma_channel_init(EDMA_1);
    #ifdef EDMA_MUX_CHCFG1_INIT
    periphMemWrite(EDMA_MUX_CHCFG1_INIT, &(DMA_MUX->chcfg[1]));
    #endif
    #endif
    #if EDMA_CHANNEL_2_INIT_USED
    #ifdef EDMA_MUX_CHCFG2_INIT
    periphMemWrite(0, &(DMA_MUX->chcfg[2]));
    #endif
    Dma_channel_init(EDMA_2);
    #ifdef EDMA_MUX_CHCFG2_INIT
    periphMemWrite(EDMA_MUX_CHCFG2_INIT, &(DMA_MUX->chcfg[2]));
    #endif
    #endif
    #if EDMA_CHANNEL_3_INIT_USED
    #ifdef EDMA_MUX_CHCFG3_INIT
    periphMemWrite(0, &(DMA_MUX->chcfg[3]));
    #endif
    Dma_channel_init(EDMA_3);
    #ifdef EDMA_MUX_CHCFG3_INIT
    periphMemWrite(EDMA_MUX_CHCFG3_INIT, &(DMA_MUX->chcfg[3]));
    #endif
    #endif
  Dma_common_init_last(EDMA);
}


void Dma_channel_init(arch_sEDMAchannel *pDmaBase)
{
#pragma unused(pDmaBase)
    
    if(pDmaBase == (arch_sEDMAchannel*)EDMA_0)
    {  
        #ifdef EDMA_TCD0_SARDR_INIT
        periphMemWrite(EDMA_TCD0_SARDR_INIT, &pDmaBase->sadr);
        #endif
        
        #ifdef EDMA_TCD0_SOFF_INIT
        periphMemWrite(EDMA_TCD0_SOFF_INIT, &pDmaBase->soff);
        #endif
        
        #ifdef EDMA_TCD0_ATTR_INIT
        periphMemWrite(EDMA_TCD0_ATTR_INIT, &pDmaBase->attr);
        #endif
        
        #ifdef EDMA_TCD0_NBYTES_MLNO_INIT
        periphMemWrite(EDMA_TCD0_NBYTES_MLNO_INIT, &pDmaBase->nbytes_mlno);
        #endif

        #ifdef EDMA_TCD0_SLAST_INIT
        periphMemWrite(EDMA_TCD0_SLAST_INIT, &pDmaBase->slast);
        #endif

        #ifdef EDMA_TCD0_DADDR_INIT
        periphMemWrite(EDMA_TCD0_DADDR_INIT, &pDmaBase->daddr);
        #endif

        #ifdef EDMA_TCD0_DOFF_INIT
        periphMemWrite(EDMA_TCD0_DOFF_INIT, &pDmaBase->doff);
        #endif

        #ifdef EDMA_TCD0_CISTER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD0_CISTER_ELINKNO_INIT, &pDmaBase->citer_elinkno);
        #endif

        #ifdef EDMA_TCD0_DLASTSGA_INIT
        periphMemWrite(EDMA_TCD0_DLASTSGA_INIT, &pDmaBase->dlastsga);
        #endif

        #ifdef EDMA_TCD0_CSR_INIT
        periphMemWrite(EDMA_TCD0_CSR_INIT, &pDmaBase->csr);
        #endif

        #ifdef EDMA_TCD0_BITER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD0_BITER_ELINKNO_INIT, &pDmaBase->biter_elinkno);
        #endif
    }
    
    if(pDmaBase == (arch_sEDMAchannel*)EDMA_1)
    {  
        #ifdef EDMA_TCD1_SARDR_INIT
        periphMemWrite(EDMA_TCD1_SARDR_INIT, &pDmaBase->sadr);
        #endif
        
        #ifdef EDMA_TCD1_SOFF_INIT
        periphMemWrite(EDMA_TCD1_SOFF_INIT, &pDmaBase->soff);
        #endif
        
        #ifdef EDMA_TCD1_ATTR_INIT
        periphMemWrite(EDMA_TCD1_ATTR_INIT, &pDmaBase->attr);
        #endif
        
        #ifdef EDMA_TCD1_NBYTES_MLNO_INIT
        periphMemWrite(EDMA_TCD1_NBYTES_MLNO_INIT, &pDmaBase->nbytes_mlno);
        #endif

        #ifdef EDMA_TCD1_SLAST_INIT
        periphMemWrite(EDMA_TCD1_SLAST_INIT, &pDmaBase->slast);
        #endif

        #ifdef EDMA_TCD1_DADDR_INIT
        periphMemWrite(EDMA_TCD1_DADDR_INIT, &pDmaBase->daddr);
        #endif

        #ifdef EDMA_TCD1_DOFF_INIT
        periphMemWrite(EDMA_TCD1_DOFF_INIT, &pDmaBase->doff);
        #endif

        #ifdef EDMA_TCD1_CISTER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD1_CISTER_ELINKNO_INIT, &pDmaBase->citer_elinkno);
        #endif

        #ifdef EDMA_TCD1_DLASTSGA_INIT
        periphMemWrite(EDMA_TCD1_DLASTSGA_INIT, &pDmaBase->dlastsga);
        #endif

        #ifdef EDMA_TCD1_CSR_INIT
        periphMemWrite(EDMA_TCD1_CSR_INIT, &pDmaBase->csr);
        #endif

        #ifdef EDMA_TCD1_BITER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD1_BITER_ELINKNO_INIT, &pDmaBase->biter_elinkno);
        #endif
    }
    
    if(pDmaBase == (arch_sEDMAchannel*)EDMA_2)
    {  
        #ifdef EDMA_TCD2_SARDR_INIT
        periphMemWrite(EDMA_TCD2_SARDR_INIT, &pDmaBase->sadr);
        #endif
        
        #ifdef EDMA_TCD2_SOFF_INIT
        periphMemWrite(EDMA_TCD2_SOFF_INIT, &pDmaBase->soff);
        #endif
        
        #ifdef EDMA_TCD2_ATTR_INIT
        periphMemWrite(EDMA_TCD2_ATTR_INIT, &pDmaBase->attr);
        #endif
        
        #ifdef EDMA_TCD2_NBYTES_MLNO_INIT
        periphMemWrite(EDMA_TCD2_NBYTES_MLNO_INIT, &pDmaBase->nbytes_mlno);
        #endif

        #ifdef EDMA_TCD2_SLAST_INIT
        periphMemWrite(EDMA_TCD2_SLAST_INIT, &pDmaBase->slast);
        #endif

        #ifdef EDMA_TCD2_DADDR_INIT
        periphMemWrite(EDMA_TCD2_DADDR_INIT, &pDmaBase->daddr);
        #endif

        #ifdef EDMA_TCD2_DOFF_INIT
        periphMemWrite(EDMA_TCD2_DOFF_INIT, &pDmaBase->doff);
        #endif

        #ifdef EDMA_TCD2_CISTER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD2_CISTER_ELINKNO_INIT, &pDmaBase->citer_elinkno);
        #endif

        #ifdef EDMA_TCD2_DLASTSGA_INIT
        periphMemWrite(EDMA_TCD2_DLASTSGA_INIT, &pDmaBase->dlastsga);
        #endif

        #ifdef EDMA_TCD2_CSR_INIT
        periphMemWrite(EDMA_TCD2_CSR_INIT, &pDmaBase->csr);
        #endif

        #ifdef EDMA_TCD2_BITER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD2_BITER_ELINKNO_INIT, &pDmaBase->biter_elinkno);
        #endif
    }
    
    if(pDmaBase == (arch_sEDMAchannel*)EDMA_3)
    {  
        #ifdef EDMA_TCD3_SARDR_INIT
        periphMemWrite(EDMA_TCD3_SARDR_INIT, &pDmaBase->sadr);
        #endif
        
        #ifdef EDMA_TCD3_SOFF_INIT
        periphMemWrite(EDMA_TCD3_SOFF_INIT, &pDmaBase->soff);
        #endif
        
        #ifdef EDMA_TCD3_ATTR_INIT
        periphMemWrite(EDMA_TCD3_ATTR_INIT, &pDmaBase->attr);
        #endif
        
        #ifdef EDMA_TCD3_NBYTES_MLNO_INIT
        periphMemWrite(EDMA_TCD3_NBYTES_MLNO_INIT, &pDmaBase->nbytes_mlno);
        #endif

        #ifdef EDMA_TCD3_SLAST_INIT
        periphMemWrite(EDMA_TCD3_SLAST_INIT, &pDmaBase->slast);
        #endif

        #ifdef EDMA_TCD3_DADDR_INIT
        periphMemWrite(EDMA_TCD3_DADDR_INIT, &pDmaBase->daddr);
        #endif

        #ifdef EDMA_TCD3_DOFF_INIT
        periphMemWrite(EDMA_TCD3_DOFF_INIT, &pDmaBase->doff);
        #endif

        #ifdef EDMA_TCD3_CISTER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD3_CISTER_ELINKNO_INIT, &pDmaBase->citer_elinkno);
        #endif

        #ifdef EDMA_TCD3_DLASTSGA_INIT
        periphMemWrite(EDMA_TCD3_DLASTSGA_INIT, &pDmaBase->dlastsga);
        #endif

        #ifdef EDMA_TCD3_CSR_INIT
        periphMemWrite(EDMA_TCD3_CSR_INIT, &pDmaBase->csr);
        #endif

        #ifdef EDMA_TCD3_BITER_ELINKNO_INIT
        periphMemWrite(EDMA_TCD3_BITER_ELINKNO_INIT, &pDmaBase->biter_elinkno);
        #endif
    }
}

void Dma_common_init(arch_sEDMA *pDmaBase)
{
#pragma unused(pDmaBase)

    #ifdef EDMA_CR_INIT
    periphMemWrite(EDMA_CR_INIT, &pDmaBase->cr);
    #endif

    #ifdef EDMA_DCHPRI0_INIT
    periphMemWrite(EDMA_DCHPRI0_INIT, &pDmaBase->dchpri[0]);
    #endif

    #ifdef EDMA_DCHPRI1_INIT
    periphMemWrite(EDMA_DCHPRI1_INIT, &pDmaBase->dchpri[1]);
    #endif

    #ifdef EDMA_DCHPRI2_INIT
    periphMemWrite(EDMA_DCHPRI2_INIT, &pDmaBase->dchpri[2]);
    #endif

    #ifdef EDMA_DCHPRI3_INIT
    periphMemWrite(EDMA_DCHPRI3_INIT, &pDmaBase->dchpri[3]);
    #endif

    #ifdef EDMA_EEI_INIT
    periphMemWrite(EDMA_EEI_INIT, &pDmaBase->eei);
    #endif

    #ifdef EDMA_EARS_INIT
    periphMemWrite(EDMA_EARS_INIT, &pDmaBase->ears);
    #endif
}

void Dma_common_init_last(arch_sEDMA *pDmaBase)
{
#pragma unused(pDmaBase)
    #ifdef EDMA_ERQ_INIT
    periphMemWrite(EDMA_ERQ_INIT, &pDmaBase->erq);
    #endif
}

#ifdef __cplusplus
}
#endif
