/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* File Name:  evtg.c
*
* Description: Source file for the EVTG driver
*
*****************************************************************************/

#include "qs.h"
#include "evtg.h"
#include "initconfig.h"

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************************
 ewtgInit() function performs the EVTG module static configuration
 based on the configurable items from appconfig.h 
********************************************************************************/

void ewtgInit(arch_sEVTG *pEvtgBase)
{
#pragma unused (pEvtgBase)

#if EVTG_A_INIT_USED && defined(EVTG_A)
    if (pEvtgBase == EVTG_A)
    {
        #ifdef EVTG_A_AOI0_BFT01_INIT
        periphMemWrite(EVTG_A_AOI0_BFT01_INIT, &pEvtgBase->aoi0_bft01);
        #endif

        #ifdef EVTG_A_AOI0_BFT23_INIT
        periphMemWrite(EVTG_A_AOI0_BFT23_INIT, &pEvtgBase->aoi0_bft23);
        #endif

        #ifdef EVTG_A_AOI1_BFT01_INIT
        periphMemWrite(EVTG_A_AOI1_BFT01_INIT, &pEvtgBase->aoi1_bft01);
        #endif

        #ifdef EVTG_A_AOI1_BFT23_INIT
        periphMemWrite(EVTG_A_AOI1_BFT23_INIT, &pEvtgBase->aoi1_bft23);
        #endif

        #ifdef EVTG_A_CTRL_INIT
        periphMemWrite(EVTG_A_CTRL_INIT, &pEvtgBase->ctrl);
        #endif

        #ifdef EVTG_A_AOI0_FILT_INIT
        periphMemWrite(EVTG_A_AOI0_FILT_INIT, &pEvtgBase->aoi0_filt);
        #endif

        #ifdef EVTG_A_AOI1_FILT_INIT
        periphMemWrite(EVTG_A_AOI1_FILT_INIT, &pEvtgBase->aoi1_filt);
        #endif
    }
    else
#endif
#if EVTG_B_INIT_USED && defined(EVTG_B)
    if (pEvtgBase == EVTG_B)
    {
        #ifdef EVTG_B_AOI0_BFT01_INIT
        periphMemWrite(EVTG_B_AOI0_BFT01_INIT, &pEvtgBase->aoi0_bft01);
        #endif

        #ifdef EVTG_B_AOI0_BFT23_INIT
        periphMemWrite(EVTG_B_AOI0_BFT23_INIT, &pEvtgBase->aoi0_bft23);
        #endif

        #ifdef EVTG_B_AOI1_BFT01_INIT
        periphMemWrite(EVTG_B_AOI1_BFT01_INIT, &pEvtgBase->aoi1_bft01);
        #endif

        #ifdef EVTG_B_AOI1_BFT23_INIT
        periphMemWrite(EVTG_B_AOI1_BFT23_INIT, &pEvtgBase->aoi1_bft23);
        #endif

        #ifdef EVTG_B_CTRL_INIT
        periphMemWrite(EVTG_B_CTRL_INIT, &pEvtgBase->ctrl);
        #endif

        #ifdef EVTG_B_AOI0_FILT_INIT
        periphMemWrite(EVTG_B_AOI0_FILT_INIT, &pEvtgBase->aoi0_filt);
        #endif

        #ifdef EVTG_B_AOI1_FILT_INIT
        periphMemWrite(EVTG_B_AOI1_FILT_INIT, &pEvtgBase->aoi1_filt);
        #endif
    }
    else
#endif
#if EVTG_C_INIT_USED && defined(EVTG_C)
    if (pEvtgBase == EVTG_C)
    {
        #ifdef EVTG_C_AOI0_BFT01_INIT
        periphMemWrite(EVTG_C_AOI0_BFT01_INIT, &pEvtgBase->aoi0_bft01);
        #endif

        #ifdef EVTG_C_AOI0_BFT23_INIT
        periphMemWrite(EVTG_C_AOI0_BFT23_INIT, &pEvtgBase->aoi0_bft23);
        #endif

        #ifdef EVTG_C_AOI1_BFT01_INIT
        periphMemWrite(EVTG_C_AOI1_BFT01_INIT, &pEvtgBase->aoi1_bft01);
        #endif

        #ifdef EVTG_C_AOI1_BFT23_INIT
        periphMemWrite(EVTG_C_AOI1_BFT23_INIT, &pEvtgBase->aoi1_bft23);
        #endif

        #ifdef EVTG_C_CTRL_INIT
        periphMemWrite(EVTG_C_CTRL_INIT, &pEvtgBase->ctrl);
        #endif

        #ifdef EVTG_C_AOI0_FILT_INIT
        periphMemWrite(EVTG_C_AOI0_FILT_INIT, &pEvtgBase->aoi0_filt);
        #endif

        #ifdef EVTG_C_AOI1_FILT_INIT
        periphMemWrite(EVTG_C_AOI1_FILT_INIT, &pEvtgBase->aoi1_filt);
        #endif
    }
    else
#endif
#if EVTG_D_INIT_USED && defined(EVTG_D)
    if (pEvtgBase == EVTG_D)
    {
        #ifdef EVTG_D_AOI0_BFT01_INIT
        periphMemWrite(EVTG_D_AOI0_BFT01_INIT, &pEvtgBase->aoi0_bft01);
        #endif

        #ifdef EVTG_D_AOI0_BFT23_INIT
        periphMemWrite(EVTG_D_AOI0_BFT23_INIT, &pEvtgBase->aoi0_bft23);
        #endif

        #ifdef EVTG_D_AOI1_BFT01_INIT
        periphMemWrite(EVTG_D_AOI1_BFT01_INIT, &pEvtgBase->aoi1_bft01);
        #endif

        #ifdef EVTG_D_AOI1_BFT23_INIT
        periphMemWrite(EVTG_D_AOI1_BFT23_INIT, &pEvtgBase->aoi1_bft23);
        #endif

        #ifdef EVTG_D_CTRL_INIT
        periphMemWrite(EVTG_D_CTRL_INIT, &pEvtgBase->ctrl);
        #endif

        #ifdef EVTG_D_AOI0_FILT_INIT
        periphMemWrite(EVTG_D_AOI0_FILT_INIT, &pEvtgBase->aoi0_filt);
        #endif

        #ifdef EVTG_D_AOI1_FILT_INIT
        periphMemWrite(EVTG_D_AOI1_FILT_INIT, &pEvtgBase->aoi1_filt);
        #endif
    }
    else
#endif
    ; /* last else case */
}


#ifdef __cplusplus
}
#endif

