/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* File Name:  ewm.c
*
* Description: Source file for the EWM Driver
*
*****************************************************************************/

#include "qs.h"
#include "ewm.h"

#ifdef __cplusplus
extern "C" {
#endif

/* initialization of EWM (external watchdog monitor) */

void ewmInit(arch_sEWM *pEwmBase)
{
#pragma unused(pEwmBase)

    #ifdef EWM_CLKPRESCALER_INIT
    periphMemWrite(EWM_CLKPRESCALER_INIT, &pEwmBase->clkprescaler);
    #endif
    
    #ifdef EWM_CLKCTRL_INIT
    periphMemWrite(EWM_CLKCTRL_INIT, &pEwmBase->clkctrl);
    #endif
    
    #ifdef EWM_CMPL_INIT
    periphMemWrite(EWM_CMPL_INIT, &pEwmBase->cmpl);
    #endif
    
    #ifdef EWM_CMPH_INIT
    periphMemWrite(EWM_CMPH_INIT, &pEwmBase->cmph);
    #endif
    
    #ifdef EWM_CTRL_INIT
    periphMemWrite(EWM_CTRL_INIT, &pEwmBase->ctrl);
    #endif

}

#ifdef __cplusplus
}
#endif
