/*******************************************************************************
*
* Copyright 2004-2016, Freescale Semiconductor, Inc.
* Copyright 2016-2019 NXP
* All rights reserved.
*
********************************************************************************
*
* $File Name: mcm_84xxx_82xxx.c$
*
* Description: Source file for the MCM Driver
*
*****************************************************************************/

#include "qs.h"
#include "mcm.h"

#ifdef __cplusplus
extern "C" {
#endif

void mcmInit(arch_sMCM *pMcmBase)
{
#pragma unused(pMcmBase)

    #ifdef MCM_CPCR_INIT   
    periphMemWrite(MCM_CPCR_INIT, &pMcmBase->cpcr);
    #endif

    #ifdef MCM_CFIER_INIT
    periphMemWrite(MCM_CFIER_INIT, &pMcmBase->cfier);
    #endif

    #ifdef MCM_CFISR_INIT
    periphMemWrite(MCM_CFISR_INIT, &pMcmBase->cfisr);
    #endif

    #ifdef MCM_UFLASHBAR_INIT
    periphMemWrite(MCM_UFLASHBAR_INIT, &pMcmBase->uflashbar);
    #endif

    #ifdef MCM_UPRAMBAR_INIT
    periphMemWrite(MCM_UPRAMBAR_INIT, &pMcmBase->uprambar);
    #endif

    #if defined(MCM_UBROMBAR_INIT) && (MCM_VERSION == 2)
    periphMemWrite(MCM_UBROMBAR_INIT, &pMcmBase->ubrombar);
    #endif

    #ifdef MCM_SRPOSP_INIT
    periphMemWrite(MCM_SRPOSP_INIT, &pMcmBase->srposp);
    #endif

    #ifdef MCM_SRPIPC_INIT
    periphMemWrite(MCM_SRPIPC_INIT, &pMcmBase->srpipc);
    #endif

    #ifdef MCM_SRPMPC_INIT
    periphMemWrite(MCM_SRPMPC_INIT, &pMcmBase->srpmpc);
    #endif

    #ifdef MCM_RPCR_INIT
    periphMemWrite(MCM_RPCR_INIT, &pMcmBase->rpcr);
    #endif
}

#ifdef __cplusplus
}
#endif
