/* app.h */
#ifndef __APP_H__
#define __APP_H__

#include <stdio.h>

#include "fsl_common.h"
#include "fsl_debug_console.h"

#include "fsl_gpio.h"

#include "lcd.h"
#include "lcd_fonts.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define APP_USER_TASK_FFT_512_IDX    0u
#define APP_USER_TASK_FFT_256_IDX    1u
#define APP_USER_TASK_FFT_128_IDX    2u
#define APP_USER_TASK_END_IDX        3u /* merge the last task into this one. */
#define APP_USER_TASK_COUNT          3u

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/* Define a type of function pointer with no parameter. */
typedef void (*Func0_T)(void);

void BOARD_InitHardware(void);

/* Touch Key. */
void     App_InitUserKey(void);
void     App_DeinitUserKey(void);
uint32_t App_GetUserKeyValue(void);

/* LCD. */
void lcd_print_string(uint16_t line_idx, char *buf, uint16_t hwColor);

int coremark_start(void);


void App_PQTask_CFFT512Case(void);
void App_PQTask_CFFT256Case(void);
void App_PQTask_CFFT128Case(void);
void App_PQInstallCallback(void (*callback)(void)); /* install the callback before start the coremark. */

#endif /* __APP_H__ */

