/*
 * Copyright (c) 2001-2004 Swedish Institute of Computer Science.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 */
#ifndef _APP_GUI_H
#define _APP_GUI_H

#include "lwip/tcp.h"
#include "app.h"
#include "BUTTON.h"

/*!
 * @brief Callback function when the checkbox is altered by the user .
 *
 * @param pMsg    Windows Manager message from emWin.
 * @retval None
 */
void GUI_Msg_Cb(WM_MESSAGE *pMsg);

/*!
 * @brief Function to clear the GUI display before updating.
 *
 * @param None
 * @retval None
 */
void Clear_LCD(void);

/*!
 * @brief Function to redraw the GUI on the LCD.
 *
 * @param num_conns    Number of active connections to update.
 * @retval None
 */
void Update_LCD(uint32_t num_conns);

/*!
 * @brief Function to update the ADC data for a particular node.
 *
 * @param node    Pointer to the TCP node which needs update.
 * @param index    Index of the node in the connection list.
 * @retval None
 */
void Update_ADC_Data(struct tcpSocket_connection *node, uint32_t index);

/*!
 * @brief Function to update LED status on the GUI.
 *
 * @param index    Index of the node in the connection list.
 * @param ledStatus    LED status 0 (off) or 1(On).
 * @retval None
 */
void Update_LED_Status(uint32_t index, uint8_t ledStatus);

#endif /* _APP_GUI_H */
