/******************************************************************************
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*  File Name: SCSI.C
*  Description: This file is to handle USB module for SD Card Reader       			    
*  Assembler:  Codewarrior for HC(S)08 V6.0
*  Version: 1.1                                                         
*  Author: Patrick Yang                              
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.09  Patrick Yang  Initial version
* 1.1   2008.08.12  Jose Ruiz     Fix Block and space variables (now supported in Linux) 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

/* Includes */
#include "SCSI.h"

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/
byte  vCBW_Buf[31];       // CBW command buffer 
byte  vUSBCBWTag[4];      // CBW tag
byte  vCSWResult;         // CSW result
byte  vIdx;               // Local index            
byte  vSD_CSD[16];        // SD card CSD vaule
byte  vSD_Bnum;           // Block number
dword vSD_LBA;            // BLock address


T32_8 u32MaxBlocks;
T16_8 u16BlockSize;



/************************************************************************************
*************************************************************************************
* Global memory declarations
*************************************************************************************
************************************************************************************/

extern word vEP1_Cnt;
extern word vEP1Idx;
extern byte vEP1Data[512];
extern word vEP2Idx;
extern byte vEP2Data[512];
extern tBDT EP2Bo;
extern byte vEP2State;
extern byte vUSB_Trf_State;


/************************************************************************************
*************************************************************************************
*                                    Funcitons                                      *
*************************************************************************************
************************************************************************************/
void SCSI_Init(void)
{
    (void)SD_Init();
    SCSI_MemoryInfo();
	USB_Init();
}

/*********************************************************
* Name: SD_ReadCSD
* Desc: Read CSD vaule of SD card
* Parameter: None
* Return: Status of read -- Fail:04  Success:00
**********************************************************/

byte SD_ReadCSD(void)
{
    byte i;
    
    SPI_SS=ENABLE;

    if(SD_SendCommand(SD_CMD9|0x40,SD_OK))
    {
        SPI_SS=DISABLE;
        return(4);      
    }
    
    while(i!=0xFE)
        i=SPI_Receive_byte();
    
    for(i=0;i<16;i++)
        vSD_CSD[i]=SPI_Receive_byte();

    (void)SPI_Receive_byte();  
    (void)SPI_Receive_byte();  

    SPI_SS=DISABLE;
    
    (void)SPI_Receive_byte();  
    
    return(0);
}



/*********************************************************
* Name: SCSI_MemoryInfo
* Desc: Storage information of SD Card
* Parameter: None
* Return: None
**********************************************************/  
void SCSI_MemoryInfo(void) 
{
    UINT16 u16Temp;

   (void)SD_ReadCSD();
	
	
    // Block Size
    u16BlockSize.u16= 1<<(vSD_CSD[5] & 0x0F);

    // Max Blocks
    u16Temp= (vSD_CSD[10]&0x80)>>7;
    u16Temp+=(vSD_CSD[9]&0x03)<<1;
    u32MaxBlocks.lword= vSD_CSD[6]&0x03;
    u32MaxBlocks.lword=u32MaxBlocks.lword<<8;
    u32MaxBlocks.lword+=vSD_CSD[7];
    u32MaxBlocks.lword=u32MaxBlocks.lword<<2;
    u32MaxBlocks.lword+=(vSD_CSD[8]&0xC0)>>6;
    u32MaxBlocks.lword++;
    u32MaxBlocks.lword=u32MaxBlocks.lword<<(u16Temp+2);
    
    // Patch for SD Cards of 2 GB
    if(u16BlockSize.u16 > 512)
    {
        u16BlockSize.u16=512;
        u32MaxBlocks.lword=u32MaxBlocks.lword<<1;
    }


}


/*********************************************************
* Name: Send_CSW
* Desc: Send CSW back to Host
* Parameter: None
* Return: None
**********************************************************/

void Send_CSW(void)
{
    vEP1Data[0] = 0x55;          // 00 byte0-3 Signature 0x55 0x53 0x42 0x52
    vEP1Data[1] = 0x53;   		    // 01 					
    vEP1Data[2] = 0x42;          // 02 
	  vEP1Data[3] = 0x53;          // 03 
	  vEP1Data[4] = vUSBCBWTag[0]; // 04 byte4-7 USB CBW Tag
	  vEP1Data[5] = vUSBCBWTag[1]; // 05 
	  vEP1Data[6] = vUSBCBWTag[2]; // 06 
	  vEP1Data[7] = vUSBCBWTag[3]; // 07 
	  vEP1Data[8] = 0x00;          // 08 byte8-11 USB byte residue 
	  vEP1Data[9] = 0x00;          // 09 
	  vEP1Data[10] = 0x00;          // 10 
	  vEP1Data[11] = 0x00;          // 11 
	  vEP1Data[12] = vCSWResult;    // 12 Status
	  
    vEP1Idx =0;
    vEP1_Cnt = 13;
    EP1_Load();
    vUSB_Trf_State = cUSBWait;
}


/*********************************************************
* Name: SCSIList00
* Desc: SCSI command 0x00 (Test unit ready) handler
* Parameter: None
* Return: None
**********************************************************/
void SCSIList00(void)
{
  vCSWResult =kCSWPass;   
  Send_CSW();
}


/*********************************************************
* Name: SCSIList03
* Desc: SCSI command 0x03 (Request Sense) handler
* Parameter: None
* Return: None
**********************************************************/
void SCSIList03(void) 
{
    vIdx=0;
    
    vEP1Data[vIdx++] = 0x70;        // 00 error code
    vEP1Data[vIdx++] = 0x00;   		  // 01 reserved				
    vEP1Data[vIdx++] = 0x05;        // 02 sense key
	vEP1Data[vIdx++] = 0x00;        // 03 03-06 information
	vEP1Data[vIdx++] = 0x00;        // 04 
	vEP1Data[vIdx++] = 0x00;        // 05 
	vEP1Data[vIdx++] = 0x00;        // 06 
	vEP1Data[vIdx++] = 0x0C;        // 07 additional sense length
	vEP1Data[vIdx++] = 0x00;        // 08 08-11 command specific information
	vEP1Data[vIdx++] = 0x00;        // 09 
	vEP1Data[vIdx++] = 0x00;        // 10 
	vEP1Data[vIdx++] = 0x00;        // 11 
	vEP1Data[vIdx++] = 0x24;        // 12 additional sense code
	vEP1Data[vIdx++] = 0x00;        // 13 additional sense code qualifer
	vEP1Data[vIdx++] = 0x00;        // 14 file replaceable unit code
	vEP1Data[vIdx++] = 0x00;        // 15 15-17 sense key specific
	vEP1Data[vIdx++] = 0x00;        // 16 
	vEP1Data[vIdx++] = 0x00;        // 17 
	  
	  
    vCSWResult =kCSWPass;  
    vEP1_Cnt = vIdx;
    EP1_Load();
    vUSB_Trf_State = cCSW; 
}


/*********************************************************
* Name: SCSIList12
* Desc: SCSI command 0x12 (Inquiry) handler
* Parameter: None
* Return: None
**********************************************************/
void SCSIList12(void) 
{
    
    vIdx=0;
    
    vEP1Data[0] = 0x00;         // 00 device type
    vEP1Data[1] = 0x80;   		// 01 removable					
    vEP1Data[2] = 0x00;         // 02 SCSI 2 compatible
	vEP1Data[3] = 0x00;         // 03 data format
	vEP1Data[4] = 0x1F;         // 04 additional lenght=31
	vEP1Data[5] = 0x00;         // 05 
	vEP1Data[6] = 0x00;         // 06 
	vEP1Data[7] = 0x00;         // 07 
	vEP1Data[8] = 'J';          // 08         
	vEP1Data[9] = 'M';          // 09 
	vEP1Data[10] ='6';          // 10 
	vEP1Data[11] ='0';          // 11 
	vEP1Data[12] =' ';          // 12 
	vEP1Data[13] ='S';          // 13 
	vEP1Data[14] ='D';          // 14 
	vEP1Data[15] =' ';          // 15 
	vEP1Data[16] ='C';          // 16 
	vEP1Data[17] ='a';          // 17 
	vEP1Data[18] ='r';          // 18 
	vEP1Data[19] ='d';          // 19 
	vEP1Data[20] =' ';          // 20  
    vEP1Data[21] ='R';          // 21 
	vEP1Data[22] ='e';          // 22 
	vEP1Data[23] ='a';          // 23 
	vEP1Data[24] ='d';          // 24 
	vEP1Data[25] ='e';          // 25 
	vEP1Data[26] ='r';          // 26 
	vEP1Data[27] = 0x20;        // 27 
	vEP1Data[28] = 0x20;        // 28 
	vEP1Data[29] = 0x20;        // 29 
	vEP1Data[30] = 0x20;        // 30 ' '
	vEP1Data[31] = 0x20;        // 31 ' '
	vEP1Data[32] = '1';         // 32 '1'
	vEP1Data[33] = '.';         // 33 '.'
	vEP1Data[34] = '0';         // 34 '0'
	vEP1Data[35] = '0';         // 35 '0'
	  
	vCSWResult = kCSWPass;
	vEP1_Cnt = 36;
    EP1_Load();
    
    vUSB_Trf_State = cCSW; 
	  
}


/*********************************************************
* Name: SCSIList1A
* Desc: SCSI command 0x1A (Mode Sense) handler
* Parameter: None
* Return: None
**********************************************************/
void SCSIList1A(void)
{
   vEP1Data[0] = 0x03;          // page mode
   vEP1Data[1] = 0x00;
   
   if(SD_WR == kSD_WP)
    vEP1Data[2]=0x80;
   else
    vEP1Data[2] = 0x00;          // unprotect, protect is 0x80
   
   vEP1Data[3] = 0x00;
   
   vCSWResult = kCSWPass;
   vEP1_Cnt = 4;
   EP1_Load();
   vUSB_Trf_State = cCSW; 
}
   
   
/*********************************************************
* Name: SCSIList23
* Desc: SCSI command 0x23 handler
* Parameter: None
* Return: None
**********************************************************/  
void SCSIList23(void) 
{
    vIdx=0;
    
    vEP1Data[0]  = 0x00; 
    vEP1Data[1]  = 0x00;
    vEP1Data[2]  = 0x00;
	vEP1Data[3]  = 0x10;
	vEP1Data[4]  = u32MaxBlocks.bytes[0];
	vEP1Data[5]  = u32MaxBlocks.bytes[1];
	vEP1Data[6]  = u32MaxBlocks.bytes[2];
	vEP1Data[7]  = u32MaxBlocks.bytes[3];
	vEP1Data[8]  = 0x02;
	vEP1Data[9]  = 0x00;
	vEP1Data[10] = u16BlockSize.u8[0];
	vEP1Data[11] = u16BlockSize.u8[1];
	vEP1Data[12] = u32MaxBlocks.bytes[0];
	vEP1Data[13] = u32MaxBlocks.bytes[1];
	vEP1Data[14] = u32MaxBlocks.bytes[2];
	vEP1Data[15] = u32MaxBlocks.bytes[3];
	vEP1Data[16] = 0x00;
	vEP1Data[17] = 0x00;
	vEP1Data[18] = u16BlockSize.u8[0];
	vEP1Data[19] = u16BlockSize.u8[1];
	  
	vCSWResult = kCSWPass;
	vEP1_Cnt = 20;
    EP1_Load();
    vUSB_Trf_State = cCSW; 
}

/*********************************************************
* Name: SCSIList25
* Desc: SCSI command 0x25 (Read Capacity) handler
* Parameter: None
* Return: None
**********************************************************/  
void SCSIList25(void) 
{
    T32_8 u32Temp;
    
    u32Temp.lword=u32MaxBlocks.lword-1;
    vIdx=0;
    
	vEP1Data[0]  = u32Temp.bytes[0];
	vEP1Data[1]  = u32Temp.bytes[1];
	vEP1Data[2]  = u32Temp.bytes[2];
	vEP1Data[3]  = u32Temp.bytes[3];
	vEP1Data[4]  = 0x00;
	vEP1Data[5]  = 0x00;
	vEP1Data[6] = u16BlockSize.u8[0];
	vEP1Data[7] = u16BlockSize.u8[1];
	  
	vCSWResult = kCSWPass;
	vEP1_Cnt = 8;
    EP1_Load();
    vUSB_Trf_State = cCSW; 
}   
   



/*********************************************************
* Name: SCSIList28
* Desc: SCSI command 0x28 (Read ) handler
* Parameter: None
* Return: None
**********************************************************/ 
void SCSIList28(void)
{
   byte i;
   
   vSD_LBA  = (dword)(vCBW_Buf[kSCSI10LBAByte3])<<24;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte2])<<16;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte1])<<8;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte0]);
   
   vSD_Bnum = vCBW_Buf[kSCSI10XferLength0];
   
   vCSWResult = kCSWPass;

   for(i=0;i<vSD_Bnum;i++)
   {     
      SD_Read_Block(vSD_LBA,vEP1Data);
      vUSB_Trf_State = cEP1Tx; 
      vEP1Idx =0;
      vEP1_Cnt=512;
      EP1_Load();
      while(vEP1_Cnt);
      vSD_LBA++;     
   }
   
   
   vUSB_Trf_State = cCSW;  
    
}




/*********************************************************
* Name: SCSIList2A
* Desc: SCSI command 0x2A (Write) handler
* Parameter: None
* Return: None
**********************************************************/
void SCSIList2A(void)
{
   byte i;
   
   vSD_LBA  = (dword)(vCBW_Buf[kSCSI10LBAByte3])<<24;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte2])<<16;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte1])<<8;
   vSD_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte0]);
   
   vSD_Bnum = vCBW_Buf[kSCSI10XferLength0];
     
   for(i=0;i<vSD_Bnum;i++)
   {     
      while(vEP2Idx !=512);
   
      SD_Write_Block(vSD_LBA,vEP2Data);  
      
      vEP2Idx =0;
      EP2Bo.Stat._byte=vEP2State;
        
      vSD_LBA++;
   }
   
   
   vCSWResult = kCSWPass;
   
   Send_CSW();
   
}




/*********************************************************
* Name: SCSI_NotSupport
* Desc: Handle Not support SCSI command 
* Parameter: None
* Return: None
**********************************************************/
void SCSI_NotSupport(void) {
  byte count;
  
  vCSWResult= kCSWFailed;
  
  
  count=vCBW_Buf[kCBWXferLength0] | vCBW_Buf[kCBWXferLength1] | vCBW_Buf[kCBWXferLength2] | vCBW_Buf[kCBWXferLength3];
  
  if(count) 
  {
    if( (vCBW_Buf[kCBWFlags] & kCBWDirection) == kHost2Device)
		{
			EPCTL2_EPSTALL =1;		// STALL OUT endpoint
			Send_CSW();
		}
		else 
		{              // device to host
		  vEP1_Cnt = 0;
		  EP1_Load();
		  vUSB_Trf_State = cCSW; 
		}
	}
	
	else									// zero data
		Send_CSW();
} 
 

/*********************************************************
* Name: SCSI_Process
* Desc: SCSI command handler
* Parameter: None
* Return: None
**********************************************************/
void SCSI_Process(void)
{
    
 
    vUSBCBWTag[0]=vCBW_Buf[kCBWTag0];
    vUSBCBWTag[1]=vCBW_Buf[kCBWTag1];
    vUSBCBWTag[2]=vCBW_Buf[kCBWTag2];
    vUSBCBWTag[3]=vCBW_Buf[kCBWTag3];   
 
    vEP1Idx =0;
 
    switch(vCBW_Buf[kCBWSCSICommand])
    {
      case 0x00:
        SCSIList00();
        break;
        
      case 0x03:
        SCSIList03();
        break;
        
      case 0x12:
        SCSIList12();
        break;
      
      case 0x1A:
        SCSIList1A();
        break;
    
      case 0x23:
        SCSIList23();
        break;

      case 0x25:
        SCSIList25();
        break;
      
      case 0x28:
        SCSIList28();
        break;
        
      case 0x2A:
        SCSIList2A();
        break;
        
      default:
        SCSI_NotSupport();
        break;
    }
      
}