/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       Calendar.c
\brief      Routines to create the Calendar functionality based on an RTC or TOD module
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Calendar.h"

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
RTC_Type Calendar_RTC;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
const UINT8 DaysPerMonth[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/* Disable Message that String is not Zero Terminated */
#pragma MESSAGE DISABLE C3401
const UINT8 MonthsNames[12][3]=
{
  "JAN",
  "FEB",
  "MAR",
  "APR",
  "MAY",
  "JUN",
  "JUL",
  "AUG",
  "SEP",
  "OCT",
  "NOV",
  "DEC"
};

const UINT8 DaysNames[7][2]=
{
  "SU",
  "MO",
  "TU",
  "WE",
  "TH",
  "FR",
  "SA"
};

/* Re-Enable Message that String is not Zero Terminated */
#pragma MESSAGE DEFAULT C3401


/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/
/****************************************************************************************************/
/**
* \brief    Initialize the Time and Date structure and calls the HW module used to start the calendar (TOD, RTC)
* \author   
* \param    UINT8 CalendarOptions 
* \param    UINT8 CalendarWakeupPeriod
* \return   void
* \todo     
*/
void vfnCalendar_Init(UINT8 CalendarOptions, UINT8 CalendarWakeupPeriod)
{
  
  vfnCalendar_SetTime(12, 0, 0);
  vfnCalendar_SetDate (9, 1, 1, _MONDAY_);

  INIT_CALENDAR_COUNTER(CalendarOptions, CalendarWakeupPeriod);

}

/**
* \brief    Routine to set the Time
* \author   
* \param    UINT8 Hours, Minutes and Seconds
* \return   void
* \todo     
*/
void vfnCalendar_SetTime (UINT8 Hours, UINT8 Minutes, UINT8 Seconds)
{
  DISABLE_CALENDAR_COUNTER();
  Calendar_RTC.Hours = Hours;
  Calendar_RTC.Minutes = Minutes;
  Calendar_RTC.Seconds = Seconds;
  
  //INIT_CALENDAR_COUNTER();
}

/**
* \brief    Routine to set the Date
* \author   
* \param    UINT8 Year, Month, Date and Day of the Week
* \return   void
* \todo     
*/
void vfnCalendar_SetDate (UINT8 Year, UINT8 Month, UINT8 Date, UINT8 Day)
{
  DISABLE_CALENDAR_COUNTER();
  Calendar_RTC.Year = Year;
  Calendar_RTC.Month = Month;
  Calendar_RTC.Date = Date;
  Calendar_RTC.Day = Day;
  /* Enable seconds interrupt and Match Event Interrupts; the match will occur every 240 counts, meaning every minute */
  //INIT_CALENDAR_COUNTER();
}

/**
* \brief    Function used to update the hours when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateHours(void)
{
  if (Calendar_RTC.Hours == 24)
  {
    Calendar_RTC.Hours = 0;
  }
  
  else if (Calendar_RTC.Hours > 24)
  {
    Calendar_RTC.Hours = 23;
  }
  
}

/**
* \brief    Function used to update the minutes when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateMinutes(void)
{
  if (Calendar_RTC.Minutes == 60)
  {
    Calendar_RTC.Minutes = 0;
  }
  
  else if (Calendar_RTC.Minutes > 60)
  {
    Calendar_RTC.Minutes = 59;
  }
}

/**
* \brief    Function used to update the Day of week when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateDay(void)
{
  if (Calendar_RTC.Day == DAYS_OF_WEEK)
  {
    Calendar_RTC.Day = 0;
  }
  
  else if (Calendar_RTC.Day > DAYS_OF_WEEK)
  {
    Calendar_RTC.Day = 6;
  }
}

/**
* \brief    Function used to update the Date when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateDate(void)
{
  if (Calendar_RTC.Date == (DaysPerMonth[Calendar_RTC.Month] + 1))
  {
    Calendar_RTC.Date = 1;
  }
  
  else if (Calendar_RTC.Date > (DaysPerMonth[Calendar_RTC.Month] + 1))
  {
    Calendar_RTC.Date = DaysPerMonth[Calendar_RTC.Month];
  }  
}

/**
* \brief    Function used to update the Month when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateMonth(void)
{
  if (Calendar_RTC.Month == MONTHS_PER_YEAR)
  {
    Calendar_RTC.Month = 0;
  }
  
  else if (Calendar_RTC.Month > MONTHS_PER_YEAR)
  {
    Calendar_RTC.Month = MONTHS_PER_YEAR - 1;
  }
}

/**
* \brief    Function used to update the Year when configuring the time using the buttons
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendarUpdateYear(void)
{
  if (Calendar_RTC.Year == 100)
  {
    Calendar_RTC.Year = 0;
  }
  
  else if (Calendar_RTC.Year > 100)
  {
    Calendar_RTC.Year = 99;
  }
}

/**
* \brief    Routine used to perform the Calendar functioality (real time). Updates the time and date when needed
* \author   
* \param    void
* \return   void
* \todo     
*/
void vfnCalendar_UpdateDateAndTime(void)
{
  if (++Calendar_RTC.Seconds >= 60)
  {
    Calendar_RTC.Seconds = 0;
    if (++Calendar_RTC.Minutes == 60)
    {
      Calendar_RTC.Minutes = 0;
      if (++Calendar_RTC.Hours == 24)
      {
        Calendar_RTC.Hours = 0;
        if (++Calendar_RTC.Day > 6)
        {
          Calendar_RTC.Day = 0;
        }
        if (++Calendar_RTC.Date > DaysPerMonth[Calendar_RTC.Month])
        {
          Calendar_RTC.Date = 1;
          if (++Calendar_RTC.Month > 11)
          {
            Calendar_RTC.Month = 0;
            Calendar_RTC.Year++;
          }
        }
      }
    }
  }
}