#include "derivative.h" /* include peripheral declarations */
#include "LCD_GD5360P.h"

UINT8 bLCD_CharPosition;


byte *bpaPlace [ ] =
{
(unsigned char *)&Char1a,		  // LCD4 --- Pin:5  LCDnAddress=4                	bLCD_CharPosition = 0x00
 (unsigned char *)&Char1b,		// LCD5 --- Pin:6  LCDnAddress=5                	bLCD_CharPosition = 0x01
 (unsigned char *)&Char1c,		// LCD6 --- Pin:7  LCDnAddress=6                	bLCD_CharPosition = 0x02
 (unsigned char *)&Char1d,   	// LCD7 --- Pin:8  LCDnAddress=7                	bLCD_CharPosition = 0x03
 (unsigned char *)&Char2a,		// LCD9 --- Pin:10  LCDnAddress=9                	bLCD_CharPosition = 0x04
 (unsigned char *)&Char2b,   	// LCD10 --- Pin:11  LCDnAddress=10                 	bLCD_CharPosition = 0x05
 (unsigned char *)&Char2c,   	// LCD11 --- Pin:12  LCDnAddress=11                	bLCD_CharPosition = 0x06
 (unsigned char *)&Char2d,   	// LCD12 --- Pin:13  LCDnAddress=12                	bLCD_CharPosition = 0x07
 (unsigned char *)&Char3a,		// LCD13 --- Pin:14  LCDnAddress=13                	bLCD_CharPosition = 0x08
 (unsigned char *)&Char3b,  	// LCD16 --- Pin:17  LCDnAddress=16                	bLCD_CharPosition = 0x09
 (unsigned char *)&Char3c,  	// LCD17 --- Pin:18  LCDnAddress=17                	bLCD_CharPosition = 0x0A
 (unsigned char *)&Char3d,		// LCD18 --- Pin:19  LCDnAddress=18                	bLCD_CharPosition = 0x0B
 (unsigned char *)&Char4a,   	// LCD24 --- Pin:25  LCDnAddress=24                	bLCD_CharPosition = 0x0C
 (unsigned char *)&Char4b,   	// LCD23 --- Pin:24  LCDnAddress=23                	bLCD_CharPosition = 0x0D
 (unsigned char *)&Char4c,		// LCD22 --- Pin:23  LCDnAddress=22                	bLCD_CharPosition = 0x0E
 (unsigned char *)&Char4d,		// LCD21 --- Pin:22  LCDnAddress=21                	bLCD_CharPosition = 0x0F
 (unsigned char *)&Char5a,		// LCD27 --- Pin:28  LCDnAddress=27                	bLCD_CharPosition = 0x10
 (unsigned char *)&Char5b,		// LCD26 --- Pin:27  LCDnAddress=26                	bLCD_CharPosition = 0x11
 (unsigned char *)&Char5c,		// LCD25 --- Pin:26  LCDnAddress=25                	bLCD_CharPosition = 0x12
 (unsigned char *)&Char5d,		// LCD21 --- Pin:22  LCDnAddress=25                	bLCD_CharPosition = 0x13
};


const byte baAlphanumeric [ ] =
{
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = 0,   offset=0
	 ( !SEGA  ), (  SEGB + !SEGF ),  (  SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = 1,   offset=4
	 (  SEGA  ), (  SEGB + !SEGF ),  ( !SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = 2,   offset=8
	 (  SEGA  ), (  SEGB + !SEGF ),  (  SEGC +  SEGG ),  (  SEGD + !SEGE ),          //Char = 3,   offset=12
	 ( !SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  ( !SEGD + !SEGE ),          //Char = 4,   offset=16
	 (  SEGA  ), ( !SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD + !SEGE ),          //Char = 5,   offset=20
	 ( !SEGA  ), ( !SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = 6,   offset=24
	 (  SEGA  ), (  SEGB + !SEGF ),  (  SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = 7,   offset=28
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = 8,   offset=32
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  ( !SEGD + !SEGE ),          //Char = 9,   offset=36
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char =       offset=40
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char =       offset=44
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char =        offset=48
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char =       offset=52
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char =       offset=56
	 (  SEGA  ), (  SEGB +  SEGF ),  ( !SEGC +  SEGG ),  ( !SEGD + !SEGE ),          //Char =       offset=60
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = @,   offset=64
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC + !SEGG ),  ( !SEGD +  SEGE ),          //Char = A,   offset=68
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = B,   offset=72
	 (  SEGA  ), ( !SEGB +  SEGF ),  ( !SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = C,   offset=76
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = D,   offset=80
	 (  SEGA  ), ( !SEGB +  SEGF ),  ( !SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = E,   offset=84
	 (  SEGA  ), ( !SEGB +  SEGF ),  ( !SEGC +  SEGG ),  ( !SEGD +  SEGE ),          //Char = F,   offset=88
	 ( !SEGA  ), ( !SEGB +  SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = G,   offset=92
	 ( !SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  ( !SEGD +  SEGE ),          //Char = H,   offset=96
	 ( !SEGA  ), (  SEGB + !SEGF ),  (  SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = I,   offset=100
	 ( !SEGA  ), (  SEGB + !SEGF ),  (  SEGC + !SEGG ),  (  SEGD + !SEGE ),          //Char = J,   offset=104
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = K,   offset=108
	 ( !SEGA  ), ( !SEGB +  SEGF ),  ( !SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = L,   offset=112
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = M,   offset=116
	 ( !SEGA  ), ( !SEGB + !SEGF ),  (  SEGC +  SEGG ),  ( !SEGD +  SEGE ),          //Char = N,   offset=120
	 ( !SEGA  ), ( !SEGB + !SEGF ),  (  SEGC +  SEGG ),  (  SEGD +  SEGE ),          //Char = O,   offset=124
	 (  SEGA  ), (  SEGB +  SEGF ),  ( !SEGC +  SEGG ),  ( !SEGD +  SEGE ),          //Char = P,   offset=128
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = Q,   offset=132
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC +  SEGG ),  ( !SEGD +  SEGE ),          //Char = R,   offset=136
	 (  SEGA  ), (  SEGB +  SEGF ),  (  SEGC +  SEGG ),  ( !SEGD + !SEGE ),          //Char = S,   offset=140
	 ( !SEGA  ), ( !SEGB + !SEGF ),  ( !SEGC + !SEGG ),  ( !SEGD + !SEGE ),          //Char = T,   offset=144
	 ( !SEGA  ), (  SEGB +  SEGF ),  (  SEGC + !SEGG ),  (  SEGD +  SEGE ),          //Char = U,   offset=148
} ;

const byte baNumeric [ ] = 
{
	(  SEG1 +  SEG2 ),  (  SEG1 + !SEG2 ),  (  SEG1 +  SEG2 ),  (  SEG1 ),          //Char = 0,   offset=0
	( !SEG1 +  SEG2 ),  ( !SEG1 + !SEG2 ),  ( !SEG1 +  SEG2 ),  ( !SEG1 ),          //Char = 1,   offset=4
	(  SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  (  SEG1 + !SEG2 ),  (  SEG1 ),          //Char = 2,   offset=8
	(  SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  (  SEG1 ),          //Char = 3,   offset=12
	( !SEG1 +  SEG2 ),  (  SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  ( !SEG1 ),          //Char = 4,   offset=16
	(  SEG1 + !SEG2 ),  (  SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  (  SEG1 ),          //Char = 5,   offset=20
	( !SEG1 + !SEG2 ),  (  SEG1 +  SEG2 ),  (  SEG1 +  SEG2 ),  (  SEG1 ),          //Char = 6,   offset=24
	(  SEG1 +  SEG2 ),  ( !SEG1 + !SEG2 ),  ( !SEG1 +  SEG2 ),  ( !SEG1 ),          //Char = 7,   offset=28
	(  SEG1 +  SEG2 ),  (  SEG1 +  SEG2 ),  (  SEG1 +  SEG2 ),  (  SEG1 ),          //Char = 8,   offset=32
	(  SEG1 +  SEG2 ),  (  SEG1 +  SEG2 ),  ( !SEG1 +  SEG2 ),  ( !SEG1 ),          //Char = 9,   offset=36
	( !SEG1 + !SEG2 ),  ( !SEG1 + !SEG2 ),  ( !SEG1 + !SEG2 ),  ( !SEG1 ),          //Char =  ,   offset=40
};


void vfnLCD_Init  (void)
{
  PTADD = 0x30;
  PTDDD = 0xFF;
  PTEDD =0xFF;
  PTAD = 0x00;
  PTDD = 0x0;
  PTED =0x00;
  
  LCDC0_INIT; 				  	// Configure  the LCD0 register
  LCDSUPPLY_INIT;			    // Configure  the Voltage Supply 
  LCDRVC_INIT;				  	// Configure  the Regulated Voltage Control
  LCDC1_INIT;				      // Configure  the LCD1 register
  LCDBCTL_INIT; 				  // Configure  the Blink Control register
  vfnEnablePins ();			  // Give to the LCDx the functionality  of a LCD pin
  vfnEnableBackplanes ();	// Enable the characterisitcs of a Backplane
  LCDEN; 						      // Enable the LCD module
}

void vfnEnablePins (void)
{
	PEN0;
	PEN1;
	PEN2;
	PEN3;
}
  
void vfnEnableBackplanes (void)
{
  LCDBPEN0 = 0x00;
  LCDBPEN1 = 0x00;
  LCDBPEN2 = 0x00;
  LCDBPEN3 = 0x00;
  
  EnableCom1;
  EnableCom2;
  
  SetCom1;
  SetCom2;
}

void vfnLCD_Home (void)
{
  bLCD_CharPosition =  0;
}

void vfnLCD_Contrast (UINT8 lbContrast)
{
  lbContrast &= 0x0F;              //Forced to the only values accepted 
  LCDRVC_RVTRIM   = lbContrast;    // Write the contrast value to the register on the mcu
}
 
void  vfnLCD_Write_Msg (UINT8 *lbpMessage, UINT8 lbSize )
{
  do
  {
    vfnLCD_Write_Char (*lbpMessage);
    lbpMessage ++;     
   }while (--lbSize);

}

void vfnLCD_ClearAlternateMsg(UINT8 lbSize)
{
  UINT8 *lbpLCDWF;

  if (bLCD_CharPosition < 0x0c)
  {
    while (lbSize--)
    {
      unsigned char lbCounter = _LCDTYPE - 1;
      
      lbpLCDWF = bpaPlace[bLCD_CharPosition++];
      *lbpLCDWF &= 0x1f;
      while (lbCounter--)
      {
        lbpLCDWF = bpaPlace[bLCD_CharPosition++];
        *lbpLCDWF &= 0x0f;
      }
    }
  }
  else
  {
    lbSize *= _LCDTYPE;
    while (lbSize--)
    {
			lbpLCDWF = bpaPlace[bLCD_CharPosition++];
			*lbpLCDWF &= 0x0f;
    }
    
  }
}

void vfnLCD_Write_Char (UINT8 lbValue)
{
  UINT8 *lbpLCDWF;
  UINT8 lbCounter = _LCDTYPE;
  UINT8 lbBackup = 1;
          
  lbValue = (lbValue-'0')*_LCDTYPE;

  if (bLCD_CharPosition == _CHARNUM*_LCDTYPE )	    		//Check if the place to write is an alphanumeric that exist
  {
  	bLCD_CharPosition = 0;
  }

         
         
  if (bLCD_CharPosition < 0x0C ) 
  {
	  while (lbCounter--)
	  {
		  if (lbCounter == 3)
		  {
  			lbpLCDWF = bpaPlace[bLCD_CharPosition];
  			lbBackup &= *lbpLCDWF;
  			//*lbpLCDWF = lbBackup + baAlphanumeric[lbValue];
  			*lbpLCDWF = (lbBackup + baAlphanumeric[lbValue]) + ((lbBackup + baAlphanumeric[lbValue]) << 4);
  		}
  		else 
  		{
  			lbpLCDWF = bpaPlace[bLCD_CharPosition];
  			//*lbpLCDWF = baAlphanumeric[lbValue];
  			*lbpLCDWF = baAlphanumeric[lbValue] + (baAlphanumeric[lbValue] << 4);
  		}
  		lbValue++;
  		bLCD_CharPosition++;
		}

  }
  else
  {
    while (lbCounter--)
    {
  		if (bLCD_CharPosition == 0x13)
  		{
  			lbpLCDWF = bpaPlace[bLCD_CharPosition];
  			//*lbpLCDWF |= baNumeric[lbValue] * 2;
  			*lbpLCDWF |= (baNumeric[lbValue] * 2) + ((baNumeric[lbValue] * 2)<<4);
  		}
  		else 
  		{
  			lbpLCDWF = bpaPlace[bLCD_CharPosition];
  			//*lbpLCDWF = baNumeric[lbValue];
  			*lbpLCDWF = baNumeric[lbValue] + (baNumeric[lbValue] << 4);
  		}
  		lbValue++;
  		bLCD_CharPosition++;
    }
  }
}

void vfnLCD_All_Segments_ON (void)
{              
   WF0ON;
   WF1ON;  
   WF2ON;
   WF3ON;
   WF4ON;
   WF5ON;
   WF6ON;  
   WF7ON;
   WF8ON;
   WF9ON;
   WF10ON;
   WF11ON;  
   WF12ON;
   WF13ON;
   WF14ON;
   WF15ON;
   WF16ON;  
   WF17ON;
   WF18ON;
   WF19ON;
   WF20ON;
   WF21ON;  
   WF22ON;
   WF23ON;
   WF24ON;
   WF25ON;
   WF26ON;  
   WF27ON;
}

void vfnLCD_All_Segments_OFF (void)
{              
     WF0OFF;
     WF1OFF;  
     WF2OFF;
     WF3OFF;
     WF4OFF;
     WF5OFF;
     WF6OFF;  
     WF7OFF;
     WF8OFF;
     WF9OFF;
     WF10OFF;
     WF11OFF;  
     WF12OFF;
     WF13OFF;
     WF14OFF;
     WF15OFF;
     WF16OFF;  
     WF17OFF;
     WF18OFF;
     WF19OFF;
     WF20OFF;
     WF21OFF;  
     WF22OFF;
     WF23OFF;
     WF24OFF;
     WF25OFF;
     WF26OFF;  
     WF27OFF;
}

