/****************************************************************************************************/
/****************************************************************************************************/
/**
Copyright (c) 2009 Freescale Semiconductor

\file       S08_Keyboard.c
\brief      Source file to use the Keyboard module of an S08 device
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "S08_Keyboard.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
UINT8 gu8KB_Status;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/
/****************************************************************************************************/
/**
* \brief    Initializes the Keyboard module
* \author   
* \param    UINT8 lu8KeyboardPinsUsed - Pins used for KB functionality
* \param    UINT8 lu8KB_Configuration - Configuration for the module (edges, levels, etc)
* \return   void
* \todo     
*/
void vfnKeyboard_Init(UINT8 lu8KeyboardPinsUsed, UINT8 lu8KB_Configuration)
{
  
  /* Configure the pins used */
  KBIPE = lu8KeyboardPinsUsed;
  
  KB_PULLUPS |= lu8KeyboardPinsUsed;
  KB_DDR &= ~lu8KeyboardPinsUsed;

  
  KBISC = lu8KB_Configuration | KBISC_KBACK_MASK;
  gu8KB_Status = 0xFF;
}


__interrupt VectorNumber_Vkeyboard void KeyboardISR(void)
{
  KBISC_KBACK = 1;
  /* Read the Keyboard Port to check the pins with a low level */
  gu8KB_Status = KB_PORT;

}