/**
Copyright (c) 2009 Freescale Semiconductor

\file       Ascii.h
\brief      Header file for the ASCII handling routines
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __TEMP_MEASUREMENT__

  #define __TEMP_MEASUREMENT__

  /*****************************************************************************************************
  * Include files
  *****************************************************************************************************/
  #include <hidef.h>
  #include "derivative.h"
  #include "S08_ADC12.h"
  
  /*****************************************************************************************************
  * Declaration of project wide TYPES
  *****************************************************************************************************/
  /** \brief State Machine for the Temperature Measurement */
  typedef enum
  {
    TEMP_MEASUREMENT_IDLE,
    TEMP_MEASUREMENT_GET_ADC_CONVERSIONS,
    GET_TEMPERATURE,
    TEMP_MEASUREMENT_GET_VDD
  }__TEMP_MEASUREMENT_SM_ENUM__;
  
  /*****************************************************************************************************
  * Definition of project wide VARIABLES
  *****************************************************************************************************/
  extern UINT16 gu16Temperature;
  extern UINT8  gu8TempMetricSystem;
  extern UINT16 gu16ADCVDD;
  extern sSM    sTempMeasurementSM;
  
  /*****************************************************************************************************
  * Definition of project wide MACROS / #DEFINE-CONSTANTS 
  *****************************************************************************************************/
  #define TEMPERATURE_MEASUREMENT_IDLE   sTempMeasurementSM.ActualState == TEMP_MEASUREMENT_IDLE
  
  #define _TEMPADC_SAMPLES_COUNT_        8
  #define TEMPERATURE_ERROR              0xffff;
  
  #define _TOTAL_METRIC_SYSTEMS_         2
  #define _CELSIUS_                      0
  #define _FAHRENHEIT_                   1
  
  #define CELSIUS_DEGREES_START          10
  #define FAHRENHEIT_DEGREES_START       50
  
  #define BANDGAP_VALUE                  117
  #define BANDGAP_CHANNEL                27
  #define THERMISTOR_CHAN                ADC1_CHAN
  #define THERMISTOR_ADC_PIN_ENABLE      APCTL1_ADPC0
  #define THERMISTOR_PIN_PULL_UP_ENABLE  PTAPE_PTAPE6 = 1
  #define TEMP_ADC_CONVERSION_READY()    (!ADC_ACTIVE_CONVERSION)
  #define TempADC_Start_conversion       ADC_Start_conversion
  
  #define DISABLE_TEMP_ADC_CHANNEL()     APCTL1 &= ~ADC1_PCTL1;\
                                         PTAD &= ~ (PTADD_PTADD6_MASK | PTADD_PTADD7_MASK);\
                                         PTADD |=  PTADD_PTADD6_MASK | PTADD_PTADD7_MASK;
                                         
                                         
  
  #define TempMeasurementInitADC()       PTAD_PTAD7 = 1;\
                                         PTADD_PTADD7 = 1;\
                                         ADC_Init((UINT16*)&gu16ADCTempChannel)
  #define TempMeasurementPollADC         ADC_Get_Conversion
  
  #define TEMP_MEASUREMENT_SET_STATE(x)  sTempMeasurementSM.ActualState = x
  #define TEMP_MEASUREMENT_NEXT_STATE(x) sTempMeasurementSM.NextState = x
  
  #define METRIC_SYSTEM_CELSIUS()        gu8TempMetricSystem == _CELSIUS_
  #define METRIC_SYSTEM_FAHRENHEIT()     gu8TempMetricSystem == _FAHRENHEIT_

  /*****************************************************************************************************
  * Declaration of project wide FUNCTIONS
  *****************************************************************************************************/
  void vfnTempMeasurementStartConversion(void);
  void vfnTempMeasurement_Init(void);
  void vfnTempMeasurementSM(void);
  
  
#endif