/**
Copyright (c) 2009 Freescale Semiconductor

\file       Thermostat_TempControl.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center
\version    1.0
\date       February/2009
*/
/********************************************************************************************
* Freescale reserves the right to make changes without further notice to any product
* herein to improve reliability, function, or design. Freescale does not assume any
* liability arising out of the application or use of any product, circuit, or software
* described herein; neither does it convey any license under its patent rights nor the
* rights of others. Freescale products are not designed, intended, or authorized for
* use as components in systems intended for surgical implant into the body, or other
* applications intended to support life, or for any other application in which the
* failure of the Freescale product could create a situation where personal injury or
* death may occur. Should Buyer purchase or use Freescale products for any such
* intended or unauthorized application, Buyer shall indemnify and hold Freescale and
* its officers, employees, subsidiaries, affiliates, and distributors harmless against
* all claims, costs, damages, and expenses, and reasonable attorney fees arising out
* of, directly or indirectly, any claim of personal injury or death associated with
* such unintended or unauthorized use, even if such claim alleges that Freescale was
* negligent regarding the design or manufacture of the part.
*
* Freescale is a registered trademark of Freescale, Inc.
********************************************************************************************/	

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __THERMOSTAT_TEMP_CONTROL__
  #define __THERMOSTAT_TEMP_CONTROL__

/*****************************************************************************************************
* Include files
*****************************************************************************************************/  
  #include "derivative.h"
  #include "FslTypes.h"
  #include "S08_Flash.h"
  #include "TempMeasurement.h"
  
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
  typedef enum
  {
    HVAC_HEATING,
    HVAC_VENTING,
    HVAC_COOLING,
    HVAC_HOLD_MODE
  }_HVAC_OUTPUT_STATUS_FLAGS_;

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
  #define HVAC_OUT              1
  #define HVAC_IN               0
  
  #define HVAC_PIN_OFF          0
  #define HVAC_PIN_ON           1
  
  #define HVAC_CHANGED_STATUS   1
  #define HVAC_SAME_STATUS      0
  
  #ifndef DAYS_OF_WEEK
    #define DAYS_OF_WEEK        7
  #endif
  
  
  
  #define HEAT_RESET_DDR        PTBDD_PTBDD6
  #define HEAT_RESET_PIN        PTBD_PTBD6
  #define HEAT_SET_DDR          PTBDD_PTBDD7
  #define HEAT_SET_PIN          PTBD_PTBD7
  #define HEAT_ON()             HEAT_RESET_PIN = 1;\
                                HEAT_SET_PIN = 0
  #define HEAT_OFF()            HEAT_RESET_PIN = 0;\
                                HEAT_SET_PIN = 1
                                
  #define THERMOSTAT_HEATING()  (gu8HVACStatus & (1<<HVAC_HEATING))


  #define VENT_RESET_DDR        PTBDD_PTBDD5
  #define VENT_RESET_PIN        PTBD_PTBD5
  #define VENT_SET_DDR          PTCDD_PTCDD3
  #define VENT_SET_PIN          PTCD_PTCD3
  #define VENT_ON()             VENT_RESET_PIN = 1;\
                                VENT_SET_PIN = 0
  #define VENT_OFF()            VENT_RESET_PIN = 0;\
                                VENT_SET_PIN = 1
  #define THERMOSTAT_VENTING()  (gu8HVACStatus & (1<<HVAC_VENTING))
                                
  #define FAN_SWITCH            PTBD_PTBD4
  #define FAN_SWITCH_EN_PULL_UP PTBPE_PTBPE4 = 1
  
  #define FAN_SWITCH_ON         FAN_SWITCH == 1
  
  
  #define COOL_RESET_DDR        PTCDD_PTCDD4
  #define COOL_RESET_PIN        PTCD_PTCD4
  #define COOL_SET_DDR          PTCDD_PTCDD5
  #define COOL_SET_PIN          PTCD_PTCD5
  #define COOL_ON()             COOL_RESET_PIN = 1;\
                                COOL_SET_PIN = 0
  #define COOL_OFF()            COOL_RESET_PIN = 0;\
                                COOL_SET_PIN = 1
                                
  #define THERMOSTAT_COOLING()  (gu8HVACStatus & (1<<HVAC_COOLING))
  
  #define THERMOSTAT_HOLD()     (gu8HVACStatus & (1<<HVAC_HOLD_MODE))
  
  /**
   * \brief Max temperature allowed to Start the Cooling sequence. The TSTAT shouldn't go above this temperature if working correctly
   */
  #define MAX_COOLING_TEMPERATURE          30
  
  /**
   * \brief Minimum temperature allowed to Start the Heating sequence. The TSTAT shouldn't go below this temp if working OK
   */
  #define MIN_HEATING_TEMPERATURE          18
  
  #define CLEAR_HVAC_FLAGS()               gu8HVACStatus = 0

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
  #pragma CONST_SEG NON_VOLATILE_DATA
    extern const UINT8 CoolingSetPoints[DAYS_OF_WEEK];
    extern const UINT8 HeatingSetPoints[DAYS_OF_WEEK];
  #pragma CONST_SEG DEFAULT
  extern UINT8 gu8HVACStatus;
  extern UINT8 gu8HoldTemperature;

  
/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
  void vfnTempControlInit(void);
  //void vfnThermostat_InitGPIO(void);
  void vfnThermostatResetOutputs(void);
  UINT8 u8ThermostatTempControl(UINT8 Temperature, UINT8 DayOfWeek);
  void vfnThermostatRunHold(UINT8 HoldTemperature);
  
#endif