/** ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**
**     @file      lin_cfg.c
**
**     @date      4:21:25 PM, Nov 19, 2018
**
**     @brief     Hardware configuration file
**
**     Copyright : 1997 - 2015 Freescale Semiconductor, Inc.
**     Copyright 2016 - 2017 NXP
**     All Rights Reserved.
**
**     THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
**     IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
**     OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**     IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
**     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**     SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**     HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**     STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**     IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
**     THE POSSIBILITY OF SUCH DAMAGE.
** ###################################################################*/

/*!
 * @file lin_cfg.c
 *
 * @page misra_violations MISRA-C:2012 violations
 *
 * @section [global]
 * Violates MISRA 2012 Advisory Rule 8.7, Could be made static.
 * Function ld_read_by_id_callout is API and shall not be made static.
 * This API is declared in lin_cfg.c so that users can configure the response
 * for  Read by ID request.
 *
 * @section [global]
 * Violates MISRA 2012 Advisory Rule 8.9, An object should be defined at block
 * scope if its identifier only appears in a single function.
 * An object with static storage duration declared at block scope cannot be
 * accessed directly from outside the block. g_lin_hardware_ifc, g_lin_tl_descriptor_array,
 * timerGetTimeIntervalCallback are dependent on user configurations,
 * so they shall be declared in lin_cfg.c.
 */

#include "lin.h"

static const l_u8 slave_node_lin_diag_services_supported[slave_node_DIAG_NUMBER_OF_SERVICES] = {0xB0,0xB2,0xB3,0xB7};
static l_u8 slave_node_lin_diag_services_flag[slave_node_DIAG_NUMBER_OF_SERVICES] = {0,0,0,0};


static lin_tl_pdu_data_t      master_node_tl_tx_queue_data[2];
static lin_tl_pdu_data_t      master_node_tl_rx_queue_data[2];

static lin_tl_pdu_data_t      slave_node_tl_tx_queue_data[2];
static lin_tl_pdu_data_t      slave_node_tl_rx_queue_data[2];

const l_ifc_handle g_lin_hardware_ifc[HARDWARE_INSTANCE_COUNT] = {master_node, INVALID_IFC, slave_node};
const l_u32 g_lin_virtual_ifc[LIN_NUM_OF_IFCS] = {0, 2};
volatile l_u8 g_buffer_backup_data[8] = {0, 0, 0, 0, 0, 0, 0, 0};

/* definition and initialization of signal array */
l_u8    g_lin_frame_data_buffer[LIN_FRAME_BUF_SIZE] =
{
  0xfc /* 0 : 11111100 */ /* start of frame master_node_Motor1Control */

  ,0x05 /* 1 : 00000101 */ /* start of frame master_node_Motor1State_Cycl */

  ,0x00 /* 2 : 00000000 */

  ,0x00 /* 3 : 00000000 */

  ,0x00 /* 4 : 00000000 */

  ,0x00 /* 5 : 00000000 */

  ,0xfe /* 6 : 11111110 */

  ,0xff /* 7 : 11111111 */ /* start of frame master_node_Motor1State_Event */

  ,0x05 /* 8 : 00000101 */

  ,0x01 /* 9 : 00000001 */

  ,0xfc /* 10 : 11111100 */ /* start of frame master_node_Motor2Control */

  ,0x00 /* 11 : 00000000 */ /* start of frame master_node_Motor2State_Cycl */

  ,0x00 /* 12 : 00000000 */

  ,0x00 /* 13 : 00000000 */

  ,0x00 /* 14 : 00000000 */

  ,0x00 /* 15 : 00000000 */

  ,0xfe /* 16 : 11111110 */

  ,0xff /* 17 : 11111111 */ /* start of frame master_node_Motor2State_Event */

  ,0x02 /* 18 : 00000010 */

  ,0x04 /* 19 : 00000100 */

  ,0x00 /* 20 : 00000000 */ /* start of frame master_node_MotorsControl */

  ,0xf0 /* 21 : 11110000 */

  ,0xff /* 22 : 11111111 */

  ,0xff /* 23 : 11111111 */

  ,0xff /* 24 : 11111111 */

  ,0xff /* 25 : 11111111 */

  ,0xff /* 26 : 11111111 */

  ,0xff /* 27 : 11111111 */

  ,0xfc /* 28 : 11111100 */ /* start of frame slave_node_Motor1Control */

  ,0x05 /* 29 : 00000101 */ /* start of frame slave_node_Motor1State_Cycl */

  ,0x00 /* 30 : 00000000 */

  ,0x00 /* 31 : 00000000 */

  ,0x00 /* 32 : 00000000 */

  ,0x00 /* 33 : 00000000 */

  ,0xfe /* 34 : 11111110 */

  ,0xff /* 35 : 11111111 */ /* start of frame slave_node_Motor1State_Event */

  ,0x05 /* 36 : 00000101 */

  ,0x01 /* 37 : 00000001 */

  ,0x00 /* 38 : 00000000 */ /* start of frame slave_node_MotorsControl */

  ,0xf0 /* 39 : 11110000 */

  ,0xff /* 40 : 11111111 */

  ,0xff /* 41 : 11111111 */

  ,0xff /* 42 : 11111111 */

  ,0xff /* 43 : 11111111 */

  ,0xff /* 44 : 11111111 */

  ,0xff /* 45 : 11111111 */
};

/* definition and initialization of signal array */
l_u8    g_lin_flag_handle_tbl[LIN_FLAG_BUF_SIZE] =
{
  0xFF /* 0: start of flag frame master_node_Motor1Control */

  ,0xFF /* 1: start of flag frame master_node_Motor1State_Cycl */

  ,0xFF /* 2: start of flag frame master_node_Motor1State_Event */

  ,0xFF /* 3: start of flag frame master_node_Motor2Control */

  ,0xFF /* 4: start of flag frame master_node_Motor2State_Cycl */

  ,0xFF /* 5: start of flag frame master_node_Motor2State_Event */

  ,0xFF /* 6: start of flag frame master_node_MotorsControl */

  ,0xFF /* 7: start of flag frame slave_node_Motor1Control */

  ,0xFF /* 8: start of flag frame slave_node_Motor1State_Cycl */

  ,0xFF /* 9: start of flag frame slave_node_Motor1State_Event */

  ,0xFF /* 10: start of flag frame slave_node_MotorsControl */
};

/* definition and initialization for flag of frame */
l_bool g_lin_frame_flag_handle_tbl[LIN_NUM_OF_FRMS] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

/*************************** Frame flag for updating signal in frame ****************/
volatile l_u8 g_lin_frame_updating_flag_tbl[LIN_NUM_OF_FRMS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};


/*****************************event trigger frame*****************************/
/* event trigger frames for master node */
static const l_frame_handle master_node_ETFrame0_info_data[2] = {

   master_node_Motor1State_Event
  

   ,master_node_Motor2State_Event
  
};

/*****************************event trigger frame*****************************/
/* event trigger frames for master node */
static const l_frame_handle slave_node_ETFrame0_info_data[1] = {

   slave_node_Motor1State_Event
  
};


static const lin_associate_frame_t master_node_ETFrame0_info = {
   2  /* Number of associated unconditional frame ID*/
   ,&master_node_ETFrame0_info_data[0]   /* Associated unconditional frame ID */
   ,(l_u8)master_node_CollisionResolvingTable  /* Collision resolver index in the schedule table, used in event trigger frame case*/
};

static const lin_associate_frame_t slave_node_ETFrame0_info = {
   1  /* Number of associated unconditional frame ID*/
   ,&slave_node_ETFrame0_info_data[0]   /* Associated unconditional frame ID */
   ,0xFF  /*this element is not use for slave node*/
};



/*****************************sporadic frame*****************************/
/*all sporadic frames for master node*/

static const l_frame_handle master_node_SporadicControlFrame_info_data[2] ={

   master_node_Motor1Control
  

   ,master_node_Motor2Control
  
};
static const lin_associate_frame_t master_node_SporadicControlFrame_info ={
   2
   ,&master_node_SporadicControlFrame_info_data[0]   
   ,0xFF
};
/**********************************  Frame table **********************************/
static const lin_frame_t lin_frame_tbl[LIN_NUM_OF_FRMS] ={

    { LIN_FRM_UNCD, 1, LIN_RES_PUB, 0, 0, 1   , (lin_associate_frame_t*)0 }

   ,{ LIN_FRM_UNCD, 6, LIN_RES_SUB, 1, 1, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 3, LIN_RES_SUB, 7, 2, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 1, LIN_RES_PUB, 10, 3, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 6, LIN_RES_SUB, 11, 4, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 3, LIN_RES_SUB, 17, 5, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 8, LIN_RES_PUB, 20, 6, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_EVNT, 3, LIN_RES_SUB, 0, 0, 0 , &master_node_ETFrame0_info }
  
   ,{ LIN_FRM_SPRDC, 1, LIN_RES_PUB, 0, 0, 0 , &master_node_SporadicControlFrame_info }
  
   ,{ LIN_FRM_DIAG, 8, LIN_RES_PUB, 0, 0, 0 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_DIAG, 8, LIN_RES_SUB, 0, 0, 0 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 1, LIN_RES_SUB, 28, 7, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 6, LIN_RES_PUB, 29, 8, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 3, LIN_RES_PUB, 35, 9, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_UNCD, 8, LIN_RES_SUB, 38, 10, 1 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_EVNT, 3, LIN_RES_PUB, 0, 0, 0 , &slave_node_ETFrame0_info }
  
   ,{ LIN_FRM_SPRDC, 1, LIN_RES_SUB, 0, 0, 0 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_DIAG, 8, LIN_RES_SUB, 0, 0, 0 , (lin_associate_frame_t*)0 }
  
   ,{ LIN_FRM_DIAG, 8, LIN_RES_PUB, 0, 0, 0 , (lin_associate_frame_t*)0 }
  
};

static l_u8 master_node_lin_configuration_RAM[master_node_LIN_SIZE_OF_CFG]= {0x00, 0x30, 0x33, 0x36, 0x31, 0x34, 0x37, 0x2D, 0x00, 0xFF, 0x3C, 0x3D ,0xFF};

static l_u8 slave_node_lin_configuration_RAM[slave_node_LIN_SIZE_OF_CFG]= {0x00, 0x30, 0x33, 0x36, 0x2D, 0x00, 0xFF, 0x3C, 0x3D ,0xFF};

static const l_u16  master_node_lin_configuration_ROM[master_node_LIN_SIZE_OF_CFG]= {0x0000, 0x30, 0x33, 0x36, 0x31, 0x34, 0x37, 0x2D, 0x00, 0xFF, 0x3C, 0x3D ,0xFFFF};
static const l_u16  slave_node_lin_configuration_ROM[slave_node_LIN_SIZE_OF_CFG]= {0x0000, 0x30, 0x33, 0x36, 0x2D, 0x00, 0xFF, 0x3C, 0x3D ,0xFFFF};

static l_u8 slave_node_lin_configured_NAD = 0x02;

static l_u8 slave_node_lin_frm_err_resp_sig[1] = {0x33};

static l_u8 slave_node_lin_response_error_byte_offset[1] = {LIN_slave_node_Motor1LinError_BYTE_OFFSET};

static l_u8 slave_node_lin_response_error_bit_offset[1] = {LIN_slave_node_Motor1LinError_BIT_OFFSET};

/**************** Node attributes Initialization  ****************************/
const lin_node_attribute_t      g_lin_node_attribute_array[LIN_NUM_OF_SLAVE_IFCS]= {
    /** slave_node **/
    {
        .configured_NAD_ptr = &slave_node_lin_configured_NAD,        /*configured_NAD*/
        .initial_NAD = 0x0A,        /*initial_NAD*/
        .serial_number = {0x1, 0x1, 0x1, 0x1},
        .product_id = {0x001E, 0x0001, 0x00},   /*{<supplier_id>,<function_id>,<variant>}*/
        .resp_err_frm_id_ptr = slave_node_lin_frm_err_resp_sig,                         /*list index of frame error*/
        .num_frame_have_esignal = 1,                                 /*number of frame contain error signal*/
        .response_error = slave_node_Motor1LinError,                  /*<interface_name>_< response_error>*/
        .response_error_byte_offset_ptr = slave_node_lin_response_error_byte_offset,                  /*<interface_name>_< response_error>*/
        .response_error_bit_offset_ptr = slave_node_lin_response_error_bit_offset,                  /*<interface_name>_< response_error>*/

        .P2_min = 100,     /*<P2_min>*/
        .ST_min = 20,     /*<ST_min>*/
        .N_As_timeout = 2000,   /*< N_As_timeout >*/
        .N_Cr_timeout = 2000,  /*<N_Cr_timeout >*/

        .number_support_sid = slave_node_DIAG_NUMBER_OF_SERVICES,
        .service_supported_ptr = slave_node_lin_diag_services_supported,
        .service_flags_ptr = slave_node_lin_diag_services_flag
    }
};

/********************** Go to sleep Initialization *************************/
/* Delay of this schedule table is: (1.4*(34+10*(8+1))*1000/LIN_speed+jitter) ms */
/* then rounded up to a value is multiple of time base */
static const lin_schedule_data_t master_node_lin_gotosleep_data[1] = {
   {master_node_MasterReq, 2, {0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}}
};


/******************** Schedule table Initialization ************************/
static const lin_schedule_data_t master_node_NormalTable_data[2] = {

   {master_node_Motor1Control, 10, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
   , {master_node_Motor1State_Cycl, 10, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
};
/******************** Schedule table Initialization ************************/
static const lin_schedule_data_t master_node_CollisionResolvingTable_data[2] = {

   {master_node_Motor1State_Event, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
   , {master_node_Motor2State_Event, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
};
/******************** Schedule table Initialization ************************/
static const lin_schedule_data_t master_node_Table2_data[3] = {

   {master_node_MotorsControl, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
   , {master_node_ETFrame0, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
   , {master_node_SporadicControlFrame, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
};


/******************** Schedule table Initialization ************************/
/* If not specify by users, then by default delay of this schedule table is: */
/* (1.4*(34+10*(8+1))*1000/LIN_speed+jitter) ms, then rounded up to a value */
/* that is multiple of time base */
static const lin_schedule_data_t master_node_MasterReqTable_data[1] = {

   {master_node_MasterReq, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
};
/******************** Schedule table Initialization ************************/
/* If not specify by users, then by default delay of this schedule table is: */
/* (1.4*(34+10*(8+1))*1000/LIN_speed+jitter) ms, then rounded up to a value */
/* that is multiple of time base */
static const lin_schedule_data_t master_node_SlaveRespTable_data[1] = {

   {master_node_SlaveResp, 2, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  
};

/********************* Schedule table structure Initialization ***************/
static const lin_schedule_t lin_schedule_tbl[LIN_NUM_OF_SCHD_TBL] ={

   /*interface_name = master_node */
   {0, LIN_SCH_TBL_NULL  ,(lin_schedule_data_t*)0 }
  
   ,{1, LIN_SCH_TBL_GO_TO_SLEEP  , &master_node_lin_gotosleep_data[0] }
  
   ,{1, LIN_SCH_TBL_DIAG  , &master_node_MasterReqTable_data[0] }
  
   ,{1, LIN_SCH_TBL_DIAG  , &master_node_SlaveRespTable_data[0] }
  
   ,{2, LIN_SCH_TBL_NORM  , &master_node_NormalTable_data[0] }
  
   ,{2, LIN_SCH_TBL_COLL_RESOLV  , &master_node_CollisionResolvingTable_data[0] }
  
   ,{3, LIN_SCH_TBL_NORM  , &master_node_Table2_data[0] }
  
};
/****************************LIN interface configuration ****************************/
const lin_protocol_user_config_t g_lin_protocol_user_cfg_array[LIN_NUM_OF_IFCS] = {

    /* Interface_name = master_node */
    {
        .protocol_version = LIN_PROTOCOL_21,         /*lin_protocol_version */
        .language_version = LIN_PROTOCOL_21,         /*lin_language_version */
        .diagnostic_class = LIN_DIAGNOSTIC_CLASS_I,            /* LIN Diagnostic Class */
        .function = (bool)LIN_MASTER,                 /*  function LIN_MASTER*/

        .number_of_configurable_frames = 11,                            /*  num_of_frames */
        .frame_start = 0,                              /*  frame_start */
        .frame_tbl_ptr = lin_frame_tbl,                                          /*  frame_tbl */

        .list_identifiers_ROM_ptr = master_node_lin_configuration_ROM,       /*  *configuration_ROM */
        .list_identifiers_RAM_ptr = master_node_lin_configuration_RAM,       /*  *configuration_RAM */
        .max_idle_timeout_cnt =  10000,     /* Max Idle Timeout Count */
        .num_of_schedules = 7,                                  /*  num_of_schedules */
        .schedule_start = 0,                                  /*  schedule_start */
        .schedule_tbl = lin_schedule_tbl,             /* schedule_tbl */

        .slave_ifc_handle = INVALID_SLAVE_INDEX,
        .master_ifc_handle = master_node_Master,
        .lin_user_config_ptr = &lin1_InitConfig0,
#if (SUPPORT_TRANSPORT_LAYER == 1U)
        .tl_tx_queue_data_ptr = master_node_tl_tx_queue_data,
        .tl_rx_queue_data_ptr = master_node_tl_rx_queue_data,
        .max_message_length = 6             /* Max message length */
#endif /* end (SUPPORT_TRANSPORT_LAYER == 1U) */
    },
    /* Interface_name = slave_node */
    {
        .protocol_version = LIN_PROTOCOL_21,         /*lin_protocol_version */
        .language_version = LIN_PROTOCOL_21,         /*lin_language_version */
        .diagnostic_class = LIN_DIAGNOSTIC_CLASS_I,            /* LIN Diagnostic Class */
        .function = (bool)LIN_SLAVE,                  /*  function LIN_SLAVE */

        .number_of_configurable_frames = 8,                            /*  num_of_frames */
        .frame_start = 11,                              /*  frame_start */
        .frame_tbl_ptr = &lin_frame_tbl[0],                                          /*  frame_tbl */

        .list_identifiers_ROM_ptr = slave_node_lin_configuration_ROM,       /*  *configuration_ROM */
        .list_identifiers_RAM_ptr = slave_node_lin_configuration_RAM,       /*  *configuration_RAM */
        .max_idle_timeout_cnt =  10000,     /* Max Idle Timeout Count */
        .num_of_schedules = 0,                                  /*  num_of_schedules */
        .schedule_start = 0,                                  /*  schedule_start */
        .schedule_tbl = (const lin_schedule_t *)0,             /* schedule_tbl */

        .slave_ifc_handle = slave_node_Slave,
        .master_ifc_handle = INVALID_MASTER_INDEX,
        .lin_user_config_ptr = &lin2_InitConfig0,
#if (SUPPORT_TRANSPORT_LAYER == 1U)
        .tl_tx_queue_data_ptr = slave_node_tl_tx_queue_data,
        .tl_rx_queue_data_ptr = slave_node_tl_rx_queue_data,
        .max_message_length = 6             /* Max message length */
#endif /* end (SUPPORT_TRANSPORT_LAYER == 1U) */
    }

};

/*FUNCTION**********************************************************************
 *
 * Function Name : ld_read_by_id_callout
 * Description   : This function is an example of response; real implementation is application-dependent
 *                 You can use one of the following define to set PCI of response frame for
 *                 this service to the correct value
 * Implements    : ld_read_by_id_callout_Activity
 *END**************************************************************************/

l_u8 ld_read_by_id_callout(l_ifc_handle iii, l_u8 id, l_u8 *data)
{
    l_u8 retval = LD_NEGATIVE_RESPONSE;

    /* Get the current configuration */
    const lin_protocol_user_config_t  *prot_user_config_ptr = &g_lin_protocol_user_cfg_array[iii];

    if (prot_user_config_ptr->function == (bool)LIN_SLAVE)
    {
        /* Following code is an example - Real implementation is application-dependent */
        /* the handling does essentially depend on the id of the requested item */
        /* This example implement with ID = 32 - LIN_READ_USR_DEF_MIN */
        if (id == LIN_READ_USR_DEF_MIN)
        {
            /*
            * id received is user defined 32
            */
            /* A positive response is ready to be sent to the user defined request */
            data[0] = (l_u8) (id + 1U);    /* Data user define */
            data[1] = (l_u8) (id + 2U);    /* Data user define */
            data[2] = (l_u8) (id + 3U);    /* Data user define */
            data[3] = (l_u8) (id + 4U);    /* Data user define */
            data[4] = (l_u8) (id + 5U);    /* Data user define */
            retval = LD_POSITIVE_RESPONSE;
        }
        else
        {
            /*
            * id received is user defined 63 - no response
            */
        }
    } /* End (conf->function == _SLAVE_) */
   return retval;
}

