/*
 * ringbuf.h
 *
 *  Created on: Jul 5, 2018
 *      Author: nxf45772
 */

#ifndef RINGBUF_H_
#define RINGBUF_H_


#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"
#include "queue.h"
#include <stdint.h>
#include "cpu.h"

#ifdef __cplusplus
extern "C" {
#endif

#define RB_OK           (STATUS_SUCCESS)
#define RB_FAIL         (STATUS_ERROR)
#define RB_DONE         (-2)
#define RB_ABORT        (-3)
#define RB_TIMEOUT      (-4)

typedef struct ringbuf *ringbuf_handle_t;

/**
 * @brief      Create ringbuffer with total size = size * block_size
 *
 * @param[in]  size        The size
 * @param[in]  block_size  The block size
 *
 * @return     ringbuf_handle_t
 */
ringbuf_handle_t rb_create(int size, int block_size);
status_t rb_destroy(ringbuf_handle_t rb);
status_t rb_abort(ringbuf_handle_t rb);
status_t rb_reset(ringbuf_handle_t rb);
int rb_bytes_available(ringbuf_handle_t rb);
int rb_bytes_filled(ringbuf_handle_t rb);
int rb_get_size(ringbuf_handle_t rb);
int rb_read(ringbuf_handle_t rb, char *buf, int len, TickType_t ticks_to_wait);
int rb_write(ringbuf_handle_t rb, char *buf, int len, TickType_t ticks_to_wait);
int rb_size_get(ringbuf_handle_t rb);
status_t rb_done_write(ringbuf_handle_t rb);



#ifdef __cplusplus
}
#endif


#endif /* RINGBUF_H_ */
