/*
 * usr7s4.c
 *
 *  Created on: Jul 10, 2018
 *      Author: nxf45772
 */


#include "usr7s4.h"
#include "string.h"
#include "serialbuf.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "CPU.h"
#include "task.h"

#define S_NUM 4
static char send_buf[128];
static char read_buf[128];
static uint8_t socket_used[S_NUM];

typedef struct{
	int state;
	usr_net_status_t net;
}usr_sysinfo_t;

static usr_sysinfo_t sysinfo;



static int parse_ok(char* data,int len){
	int i;
	for(i=0;i<len-1;i++){
		if(data[i]=='O'&&data[i+1]=='K'){
			return 1;
		}
	}
	return 0;
}
static int socket_sdp(int enable){
	if(enable){
		sprintf(send_buf+6,"AT+SDPEN=%s\r\n","ON");
	}else{
		sprintf(send_buf+6,"AT+SDPEN=%s\r\n","OFF");
	}
	serial_send(send_buf,strlen(send_buf));
	int len=serial_read(read_buf,128);
	if(!parse_ok(read_buf,len)){
		return -1;
	}
	return 0;
}
int socket(socket_t* s){
	if(socket_used[s->client_num]!=0)
		return -1;
	char type[4]={0};
	if(s->type==USR_TCP){
		strcpy(type,"TCP");
	}else{
		strcpy(type,"UDP");
	}
	sprintf(send_buf+6,"AT+SOCK%c=%s,%s,%d\r\n",0x41+s->client_num,type,s->domain,s->port);
	serial_send(send_buf,strlen(send_buf));
	int len=serial_read(read_buf,128);
	if(!parse_ok(read_buf,len)){
		return -1;
	}
	if(s->time==USR_CONN_LONG){
		sprintf(send_buf+6,"AT+SOCK%cSL=%s\r\n",0x41+s->client_num,"LONG");
	}else{
		sprintf(send_buf+6,"AT+SOCK%cSL=%s\r\n",0x41+s->client_num,"SHORT");
	}
	serial_send(send_buf,strlen(send_buf));
	len=serial_read(read_buf,128);
	if(!parse_ok(read_buf,len)){
		return -1;
	}
	return s->client_num;
}
int connect(int fd){
	if(sysinfo.state!=2){
		return -1;
	}
	sprintf(send_buf+6,"AT+SOCK%cEN=%s\r\n",0x41+fd,"ON");
	serial_send(send_buf,strlen(send_buf));
	int len=serial_read(read_buf,128);
	if(!parse_ok(read_buf,len)){
		return -1;
	}
	sprintf(send_buf+6,"AT+SOCK%cLK\r\n",0x41+fd);
	char* pos=NULL;
	uint32_t cnt=0;
	do{
		serial_send(send_buf,strlen(send_buf));
		len=serial_read(read_buf,128);
		read_buf[len]=0;
		pos=strchr(read_buf,':');
		if(!strncmp(pos+1,"ON",2)){
			socket_used[fd]=1;
			return 0;
		}else{
			cnt++;
		}
		vTaskDelay(1000);
	}while(cnt<5);
	socket_used[fd]=0;
	return -1;
}
int close(int fd){
	if(socket_used[fd]!=1){
		return -1;
	}
	sprintf(send_buf+6,"AT+SOCK%cEN=%s\r\n",0x41+fd,"OFF");
	serial_send(send_buf,strlen(send_buf));
	int len=serial_read(read_buf,128);
	if(!parse_ok(read_buf,len)){
		return -1;
	}
	socket_used[fd]=0;
	return 0;
}
int socket_write(int fd,char* data,int len){
	memcpy(send_buf,data,len);
	serial_send(send_buf,len);
	return len;
}
int socket_read(int fd,char *data,int len){
	return serial_read(data,len);
}
static int usr7s4_check_net(usr_sysinfo_t* info){
	strcpy(send_buf+6,"AT+SYSINFO\r\n");
	serial_send(send_buf,strlen(send_buf));
	int len=serial_read(read_buf,128);
	read_buf[len]=0;
	char* pos=NULL;
	pos=strchr(read_buf,':');
	if(pos==NULL)
		return -1;
	info->state=atoi(pos+1);
	if(!strncmp(pos+3,"No Network",10)){
		info->net=USR_NO_NET;
	}else if(!strncmp(pos+3,"GSM/GPRS",8)){
		info->net=USR_NET_GSM;
	}else if(!strncmp(pos+3,"WCDMA",5)){
		info->net=USR_NET_WCDMA;
	}else if(!strncmp(pos+3,"TD-SCDMA",8)){
		info->net=USR_NET_TD;
	}else if(!strncmp(pos+3,"LTE",3)){
		info->net=USR_NET_LTE;
	}else{
		info->net=USR_NET_ERR;
	}
	return 0;
}

void usr7s4_poll_task(){
	while(1){

	}
}
void usr7s4_init(){
	int len;
	memset(send_buf,0,128);
	strcpy(send_buf,"usr.cn");
	do{
		serial_send("usr.cnAT\r\n",10);
		len=serial_read(read_buf,128);
	}while(!parse_ok(read_buf,len));
	PINS_DRV_SetPins(PTE,(1<<22U));

	usr7s4_check_net(&sysinfo);

	//socket_sdp(0);//disable tcp distibute;
	int i;
	for(i=0;i<S_NUM;i++){
		socket_used[i]=0;
	}
}





