/*
 * UART_Printf.c
 *
 *  Created on: Jun 21, 2018
 *      Author: nxa07657
 */
#include "cpu.h"
#include "UART.h"
#include "S32K148_TBOX_BSP.h"

#define UART_CONSOLE  2

#if (UART_CONSOLE==0)/* use LPUART0 on PTB0/1 */

#define CONSOLE_UART  &uart_pal1_instance
#define UART_CONFIG   &uart_pal1_Config0

#else

#if(UART_CONSOLE==1) /* use LPUART1 on PTC8/9 */

#define CONSOLE_UART  &uart_pal2_instance
#define UART_CONFIG   &uart_pal2_Config0

#else if(UART_CONSOLE==2) /* use LPUART2 on PTD17 and PTE12 */

#define CONSOLE_UART  &uart_pal3_instance
#define UART_CONFIG   &uart_pal3_Config0

#endif

#endif

UARTError InitializeUART(UARTBaudRate baudRate)
{
	/* Initialize UART PAL */
//	UART_Init(CONSOLE_UART, UART_CONFIG);

	return kUARTNoError;
}

UARTError WriteUARTN(const void * bytes, unsigned long length)
{
	UARTError err = kUARTNoError;
	uint32_t Byte_Left = 0;

	/*
	 * call LINFlexD to send several bytes
	 */
	err = UART_SendData(CONSOLE_UART,(const char * const)bytes,length);

	/*wait for transmit complete*/
	while(STATUS_SUCCESS !=  UART_GetTransmitStatus(CONSOLE_UART,&Byte_Left));

  	return err;
}

UARTError ReadUARTN(void* bytes, unsigned long limit)
{
	UARTError err;

	/*
	 * call LINFlexD to receive several byte within 1000 count delay
	 */
	err = UART_ReceiveDataBlocking(CONSOLE_UART,bytes,limit,1000);

	return err;
}

UARTError ReadUARTPoll(char* c)
{
    UARTError err = kUARTNoError;

    /*
     * call UART to receive several bytes within 1000 count delay
    */
    err = UART_ReceiveDataBlocking(CONSOLE_UART,c,1,100);

     return err;
}

#ifndef UART_PRINTF_ENABLE
/**********************************************************************
 * put this blank printf function here to replace the one in stio.h
 * in case user does not need it for debug
 *********************************************************************/
int printf(const char * format, ...)
{
	/*do nothing*/

}
/********************************************************************
 * this function will be call if use printf("xxxx\n")
 * so it is necessary to make it blank
 ********************************************************************/
int puts(const char * s)
{
	/*do nothing*/
}

#endif
