/*
 * BLE_HC08.h
 *
 *  Created on: Jun 29, 2018
 *      Author: nxa07657
 */

#ifndef BLE_HC08_H_
#define BLE_HC08_H_

#include "cpu.h"

#include "S32K148_TBOX_BSP.h"

#define HC08_NAME_MAX_LENGTH 12  /*this define the maximum length the BLE module name can accept*/

#define INFO_LENGTH  512 /*control the BLE module information array length*/

#if (UART_BLE==0)

#define BLE_UART  &uart_pal1_instance

#else

#if(UART_BLE==1)

#define BLE_UART  &uart_pal2_instance

#else if(UART_BLE==2)

#define BLE_UART  &uart_pal3_instance

#endif

#endif

#define CHECK_MODULE_DETAILS_ENABLE 1

status_t Response_Check(uint8_t *Response, uint8_t *Anwser, uint8_t Length);
status_t BLE_HC08_UART_Check( void );
status_t BLE_HC08_Factory_Recover( void );
status_t BLE_HC08_Reset( void );
status_t BLE_HC08_GetName( uint8_t *Name, uint8_t *Length );
status_t BLE_HC08_SetName( uint8_t *Name );
status_t BLE_HC08_Set_Baudrate( uint32_t Baudrate );

status_t BLE_HC08_Test(void);

#endif /* BLE_HC08_H_ */
