#ifndef S32K148_TBOX_BSP_H

#define S32K148_TBOX_BSP_H 1

#include "Cpu.h"

/********************************************************************************
 * the 3 on-board user RGB LED connection
 ********************************************************************************/
#define LED_GPIO_PORT      PTE
#define LED_RED        	   21U
#define LED_GREEN          22U
#define LED_BLUE           23U

/*use this macro to turn on the led, which can be one of any LED_RED, LED_GREEN and LED_BLUE*/
#define Turn_On_LED(led)  PINS_DRV_SetPins(LED_GPIO_PORT, (1<<led))

/*use this macro to turn on the led, which can be one of any LED_RED, LED_GREEN and LED_BLUE*/
#define Turn_Off_LED(led)  PINS_DRV_ClearPins(LED_GPIO_PORT, (1<<led))

/*use this macro to toggle the led, which can be one of any LED_RED, LED_GREEN and LED_BLUE*/
#define Turn_Toggle_LED(led)  PINS_DRV_TogglePins(LED_GPIO_PORT, (1<<led))

/*use this macro to turn on all LED_RED, LED_GREEN and LED_BLUE*/
#define Turn_On_All_LED()  PINS_DRV_SetPins(LED_GPIO_PORT, ((1<<LED_RED)|(1<<LED_GREEN)|(1<<LED_BLUE)))

/*use this macro to turn off all LED_RED, LED_GREEN and LED_BLUE*/
#define Turn_Off_All_LED()  PINS_DRV_ClearPins(LED_GPIO_PORT, ((1<<LED_RED)|(1<<LED_GREEN)|(1<<LED_BLUE)))

/********************************************************************************
 * the 2 on-board user button connection
 ********************************************************************************/
#define BIN_GPIO_PORT      PTC
#define BIN_PORT    	   PORTC
#define BUTTON_BIN0        12U
#define BUTTON_BIN1        13U

/********************************************************************************
 * the on-board touch sensor pads connection
 ********************************************************************************/
#define TOUCH_ADC0_A       0U
#define TOUCH_ADC0_B       1U
#define TOUCH_ADC1_A       12U
#define TOUCH_ADC1_B       13U

/********************************************************************************
 * the on-board Potentiometer ADC channel connection
 * selected by R117 and R124
 ********************************************************************************/
#if 0     					/*if mount R117 and DNP R124*/
#define POT_ADC            1
#define POT_ADC_CH         ADC_INPUTCHAN_EXT15 /*external channel 15 on PTB16*/

#else						/*if mount R124 and DNP R117, the default configuration*/
#define POT_ADC            0
#define POT_ADC_CH         ADC_INPUTCHAN_EXT28  /*external channel 28 on PTC28*/
#endif

/*********************************************************************************
 * the MCU VDD configuration
 ********************************************************************************/
#ifdef MCU_VDD_5V
#define ADC_RefVoltage 5.0
#else
#define ADC_RefVoltage 3.3
#endif

/********************************************************************************
 * the 2 ECU external ADC channels connection
 * which can be used to sample external analog input signals
 ********************************************************************************/

#define BOARD_REV_B 1   /*enable this macro to use Rev B board, or use Rev A board*/

#ifdef BOARD_REV_B
#define ECU_EXT_ADC        	  0      			  /*ADC0 module*/
#define ECU_EXT_ADC1_CH       ADC_INPUTCHAN_EXT6  /*external channel 6 on PTB2*/
#define ECU_EXT_ADC2_CH       ADC_INPUTCHAN_EXT7  /*external channel 7 on PTB3*/
#else
#define ECU_EXT_ADC        	  0      			  /*ADC0 module*/
#define ECU_EXT_ADC1_CH       ADC_INPUTCHAN_EXT2  /*external channel 2 on PTA6*/
#define ECU_EXT_ADC2_CH       ADC_INPUTCHAN_EXT3  /*external channel 3 on PTA7*/
#endif

/*********************************************************************************
 * the ECU external analog input circuit voltage divide factor
 * configure it as the hardware design,:
 * (100K//150K + 470K)/(100K//150K)== 53/6
 ********************************************************************************/
#define ECU_EXT_AD_FACTOR  (ADC_RefVoltage*53/6)

/********************************************************************************
 * the 2 GPIO used for:
 *  1) Accelerator(MMA8452Q)
 *  2) external RTC chip(PCA85063ATT)
 *  interrupt inputs
 *
 *  PTD23 is connected to ACC_INT2 by R227 while connected to RTC_INT by R228
 *  by default: mount R228 and DNP R227, so RTC_INT is selected
 *
 ********************************************************************************/
#define ACC_INT_GPIO_PORT  PTD
#define ACC_INT1           22U
#define ACC_INT2           23U   /*this pin is also shared with RTC_INT*/

/********************************************************************************
 * the I2C module and salve address determined by hardware configuration for:
 *  1) Accelerator(MMA8452Q)
 *  2) external RTC chip(PCA85063ATT)
 ********************************************************************************/
#define ACC_RTC_I2C        LPI2C1
#define RTC_ADDR           0x51  /* 7-bit slave address of PCA85063A */
#define ACC_ADDR           0x1D  /* 7-bit slave address of MMA8452Q  */

/********************************************************************************
 * the GPIO used to control external active oscillator for S32K148 internal RTC module connection
 ********************************************************************************/
#define RTC_CLK_CTRL_PORT   PTA
#define RTC_CLIKIN    		7u  /*PTA7*/
#define RTC_CLIKEN    		6u  /*PTA6*/

/*output low level to disable external 32.768KHz RTC clock*/
#define RTC_CLK_DISABLE()  PINS_DRV_ClearPins(RTC_CLK_CTRL_PORT,(1<<RTC_CLIKEN))
/*output high level to enable external 32.768KHz RTC clock*/
#define RTC_CLK_ENABLE()   PINS_DRV_SetPins(RTC_CLK_CTRL_PORT,(1<<RTC_CLIKEN))

#define TBOX_CAN0 &can_pal1_instance  /*the CAN0 on the T-BOX board is mapped to CAN_PAL component 1 which using FlexCAN0*/
#define TBOX_CAN1 &can_pal2_instance  /*the CAN0 on the T-BOX board is mapped to CAN_PAL component 2 which using FlexCAN1*/
#define TBOX_CAN2 &can_pal3_instance  /*the CAN0 on the T-BOX board is mapped to CAN_PAL component 3 which using FlexCAN2*/

/********************************************************************************
 * the GPIO used to control TJA1043 CAN transceiver
 ********************************************************************************/
#define TJA1043_CTRL_GPIO_PORT  PTB
#define TJA1043_CTRL_EN         11U  /*active high*/
#define TJA1043_CTRL_STB_N      15U  /*active low*/

/********************************************************************************
 * the GPIO used to control TJA1044 CAN transceiver
 ********************************************************************************/
#define TJA1044_CTRL_GPIO_PORT  PTC
#define TJA1044_CTRL_STB        11U  /*active high*/

/********************************************************************************
 * the SPI interface for UJA1132(SBC) configuration and status read
 ********************************************************************************/
#define UJA1132_CTRL_SPI  	 1 		/*use LPSPI1*/
#define UJA1132_CTRL_SPI_GPIO_PORT  PTA
#define UJA1132_CTRL_SPI_CS   26U  /*chip select, active low*/
#define UJA1132_CTRL_SPI_SCK  28U  /*serial clock, idle is high*/
#define UJA1132_CTRL_SPI_MISO 29U  /*Master Input Slave Output*/
#define UJA1132_CTRL_SPI_MOSI 27U  /*Master Output Slave Input*/

/********************************************************************************
 * the ECU_EXT_HS used to drive High Side driver for external motor or relay control
 * assigned FlexTimer FTM7 channel 1 and channel 3 to output PWM signal and driver
 ********************************************************************************/
#define ECU_EXT_HS_FTM    	 7U

#define ECU_EXT_HS1_CH       1U
#define ECU_EXT_HS2_CH       3U

/********************************************************************************
 * the ECU_EXT_PWM_IN used for external input square wave signal measurement
 * assigned to FTM6 channel 0 and channel 1 with Input Capture
 ********************************************************************************/
#define ECU_EXT_PWM_IN_FTM   6U

#define ECU_EXT_PWM_IN1_CH   0U
#define ECU_EXT_PWM_IN2_CH   2U

/********************************************************************************
 * define the UART for BLE, GPS and 4G module
 *******************************************************************************/

#define UART_BLE   0 /*use LPUART0 for BLE module communication*/
#define UART_GPS   1 /*use LPUART0 for GPS module communication*/
#define UART_4G    2 /*use LPUART0 for 4G module communication*/

/********************************************************************************
 * the ADC and GPIO for user touch pad input
 *******************************************************************************/
#define TOUCH_PAD0_ADC   		ADC0
#define TOUCH_PAD0_ADC_CH       0  /*on the PTA0*/
#define TOUCH_PAD0_GPIO_PORT    PTA
#define TOUCH_PAD0_GPIO_PIN     15 /*on the PTA15*/

#define TOUCH_PAD1_ADC   		ADC0
#define TOUCH_PAD1_ADC_CH       1  /*on the PTA1*/
#define TOUCH_PAD1_GPIO_PORT    PTA
#define TOUCH_PAD1_GPIO_PIN     16 /*on the PTA16*/


#include "BLE_HC08.h"

#include "GPS_NEO_6M.h"

#include "PCA85063A_RTC.h"

#include "MMA845x.h"

#define UART_PRINTF_ENABLE  1 /*Macro to enable the printf debug over LPUART0/1/2*/

#ifdef UART_PRINTF_ENABLE

#include "stdio.h"

#else

extern int printf(const char * format, ...);
extern int puts(const char * s);

#endif /*end of UART_PRINTF_ENABLE*/

#endif /*end of S32K148_TBOX_BSP_H*/
