/*
 * S32K148_TBOX_BSP_test_Config.h
 *
 *  Created on: Sep 28, 2018
 *      Author: nxa07657
 */

#ifndef S32K148_TBOX_BSP_TEST_CONFIG_H_
#define S32K148_TBOX_BSP_TEST_CONFIG_H_

#define Moudle_BLE_test 1

#define Moudle_GPS_test 1

//#define Moudle_4G_test 1

#if((Moudle_BLE_test==1)||(Moudle_GPS_test==1)||(Moudle_4G_test==1))

#ifndef UART_test
#define UART_test 1  	/*ensure the LPUART is initialized before use it*/
#endif

#endif

#ifdef LIN_test

#define LIN1_test 1 	/*it requires to configure UART0 TX/RX on PTA3/2*/
#define LIN2_test 1 	/*it requires to configure UART0 TX/RX on PTA9/8*/

#endif

#ifdef UART_test

//#define UART1_test  1	  /* enable this macro to test LPUART0, it requires to configure UART0 TX/RX on PTB1/0 */
//#define UART2_test  1   /* enable this macro to test LPUART1 */
//#define UART3_test  1   /* enable this macro to test LPUART2,it requires to configure UART0 TX/RX on PTE12/PTD17 */

#endif /*UART_test*/

#define PCA85063A_RTC_test 1	/* enable this macro to test the external stand alone RTC chip*/
#define MMA845x_ACC_test  1  	/* enable this macro to test the MMA8452Q accelerator*/
#define Internal_RTC_test 1	 	/* enable this macro to test the S32K148 internal RTC */

#define UES_EXT_RTC_CLK_IN 1    /*enable this macro to use external 32.768KHz RTC_CLK_IN as RTC clock source*/
#define SRC_RTC_CLK_IN 0x2      /*select 32.768KHz RTC_CLK_IN as clock source*/

/*
 * to test UART, please enable Processor EXpert component uart_pal1/2/3
 * to test LIN, please enable Processor EXpert component lin1/2 and timing_pal2
 * the above two component group cannot be enabled at the same time
 */
/*it cannot be enabled while LIN_test enabled, for the UART1/2 are reused with UART1/2*/
//#define UART_test 1  			/* enable this macro to test LPUART */
/* enable this macro to test LIN over LPUART */
//#define LIN_test 	1  /*it cannot be enabled while UART_test enabled, for the UART1/2 are reused with UART1/2*/

#define Button_test 1  			/* enable this macro to test user bottom by GPIO IRQ with rising edge trigger*/
//#define Timer_RGB_LED_test 1  /* enable this macro to test user RGB LED by periodic timer interrupt */

#define CAN_test 	1 			/* enable this macro to test CAN communication */

#ifdef CAN_test

#define CAN0_test 1 		/* enable this macro to test FlexCAN0 via SBC-UJA1132 integrated CAN transceiver*/
#define CAN1_test 1 		/* enable this macro to test FlexCAN1 via TJA1044  CAN transceiver*/
#define CAN2_test 1 		/* enable this macro to test FlexCAN2 via TJA1043  CAN transceiver*/

//#define CAN0_TRX_Polling_Method 1 /*enable this macro to use SDK status polling API for TX/RX, disable to use IRQ interrupt event callback*/
//#define CAN1_TRX_Polling_Method 1 /*enable this macro to use SDK status polling API for TX/RX, disable to use IRQ interrupt event callback*/
//#define CAN2_TRX_Polling_Method 1 /*enable this macro to use SDK status polling API for TX/RX, disable to use IRQ interrupt event callback*/

#endif/*end of CAN_test*/


/*
 * CAN0 configure to TX/RX CAN-FD message with 64B data and 2Mbit/s data rate
 * under this configuration available MB number is 0~6
 */
#define CAN0_TX_BUFF_IDX    1U		/*define the message buffer index used for CAN0 test message transmit*/
#define CAN0_RX_BUFF_IDX    0U	    /*define the message buffer index used for CAN0 test message receive*/

/*
 * CAN1 configure to TX/RX CAN 2.0 A/B message with RX FIFO and 8 RX ID filter elements
 * with RX FIFO enabled, MB0~M5 are used for RX FIFO, MB6~M7 used to store 8 RX ID filter elements
 * so TX can only use MB8~MB31
 */
#define CAN1_TX_BUFF_IDX    8U		/*define the message buffer index used for CAN1 test message transmit*/
#define CAN1_RX_BUFF_IDX    0U	    /*define the message buffer index used for CAN1 test message receive*/

/*
 * CAN2 configure to TX/RX CAN 2.0 A/B message without RX FIFO
 */
#define CAN2_TX_BUFF_IDX    1U		/*define the message buffer index used for CAN2 test message transmit*/
#define CAN2_RX_BUFF_IDX    0U	    /*define the message buffer index used for CAN2 test message receive*/

//#define Stinger_test 1        /* enable this macro to test the Stinger--A special CAN transceiver with security feature */

#define ADC_test 	        1	/* enable this macro to test ADC */
#define ECU_EXT_ADC_test 	1   /*enable this macro to test ECU external analog input ADC sample circuit*/
#define POT_ADC_test        1 	/*enable the macro test the on-board Potentiometer(POT) input analog signal voltage sample */

#define TSS_test            1	/* enable this macro to test TSS--Touch Sensing, there are 2 independent touch pad on the board */

#define PWM_HS_Timer_IC_Test 1  /* enable this macro to test the PWM High Side output and PWM signal input capture over FlexTimer module */

#ifdef PWM_HS_Timer_IC_Test
#define ECU_EXT_HS_test 		1 /*enable this macro to test PWM high side output, need to pull-up resistor R425 and R426 to output PWM HS driver signal with frequency <=20HKz*/
#define ECU_EXT_PWM_IN_test 	1 /*enable this macro to test PWM signal input measurement*/
#endif


#include <TSS_ADC_PWM_HS_RGBLED_Timer_BSP.h>
#include <UART_BSP.h>
#include <CAN_BSP.h>
#include <LIN_BSP.h>

#endif /* S32K148_TBOX_BSP_TEST_CONFIG_H_ */
