/*****************************************************************************
 *   pwmtest.c:  main C entry file for NXP LPC23xx/24xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *	 Authur: C.J.M.Jansen
 *   History
 *   2007.06.22  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#include "LPC23xx.h"                        /* LPC23xx/24xx definitions */
#include "type.h"
#include "pwm.h"


extern volatile DWORD match_counter1, match_counter0, variable;


/******************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{	

	DWORD step;
	DWORD Status;
	/* The test is done on the Keil MCB2300 board and Embedded Artist LPC24xx board	*/

 	step= 0;
 	Status= PWM_Init();
    
	PINMODE2 = 0; 	 		 // P1.0-P1.15 push pull
	PINMODE3 = 0;			 // P1.16-P1.31 push pull (default)
	SCS = SCS | 1;			 // GPIO port 0, 1 are "high speed"  (not necessary for P2,3,4)
	FIO1MASK = 0;			 // all pins are affected by FIOSET,FIOCLR,FIOPIN (default)
	FIO1DIR= 0xf0000000;	 // Pin P1.31 til P1.28 are output
 
    while ( 1 )
    {
//		if (match_counter1 == 0x00002000)
		if (match_counter1 == 0x0000060)
		{
		match_counter1= 0;
		step= step+1;
		PWM_switch(step);	 	//next conversion	
//		PWM_switch_test(step);  //next conversion for LPC23xx	
		if (step== 6) step = 0; 
//		if (step== 3) step = 0; // for LPC23xx
	   	}
	if (step==1) FIO1SET= 0xf0000000;  // for test
	if (step==2) FIO1CLR= 0xf0000000;  // for test		
	}
  	
}

/******************************************************************************
**                            End Of File
******************************************************************************/
