/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file ftm.c
*
* @author a13984
*
* @version 0.0.1
*
* @date Aug 4, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#include "common.h"
#include "ftm.h"

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/


/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: FTM2_Init
*
* @brief Initialize the FTM2 for complementary channel mode.
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void FTM2_Init(void)
{
	/* FTM2 runs 1000 times slower than the fixed clock */
	FTM2_MODE_FTMEN = 1; /* Enable the FlexTimer */
	FTM2_COMBINE1 = 0x03; /* Combine channels 2 and 3 as complementary mode */
	                      /* Set on channel 2 match, Clear on channel 3 match */
	FTM2_CNT =  0;	   /* initialize counter */	
	FTM2_MOD =  FTM2_MOD_INIT;  /* 1000 cycle PWM period */
	asm{
		nop
		nop
	}
	if(FTM2_MOD != FTM2_MOD_INIT)
	{
		//asm(BGND);
		asm(nop);
	}
	FTM2_C0SC = 0x28;   /* No Interrupts; High true pulses; Clear on Match */
	FTM2_C1SC = 0x28;   /* No Interrupts; High true pulses; Clear on Match */
	FTM2_C2SC = 0x28;   /* No Interrupts; High true pulses */
	FTM2_C3SC = 0x28;   /* No Interrupts; High true pulses */
	                       
	FTM2_C0V =  FTM2_C0V_INIT;  /* match after 200 cycles */                     
	FTM2_C1V =  FTM2_C1V_INIT;  /* match after 700 cycles */                     
	FTM2_C2V =  FTM2_C0V_INIT;  /* match after 200 cycles */                     
	FTM2_C3V =  FTM2_C3V_INIT;  /* match after 700 cycles */ 
#if (FTM2_CLK == SYS_CLK)
	FTM2_SC = 0x08;     /* No Interrupts; Output Compare running from system CLK */	
#elif (FTM2_CLK == FIXED_CLK)	
	FTM2_SC = 0x10;     /* No Interrupts; Output Compare running from fixed CLK */
#elif (FTM2_CLK == EXT_CLK)	
	FTM2_SC = 0x18;     /* No Interrupts; Output Compare running from external CLK */
#elif (FTM2_CLK == SYS_CLK_DIV_2)
	FTM2_SC = 0x08;     /* No Interrupts; Output Compare running from system/2 CLK */	
#else
#error "FTM2_Init: no such clock source supported!\n"
#endif
}

