/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file tsi.h
*
* @author B37531
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief application entry point which performs application specific tasks. 
*
******************************************************************************/
#ifndef TSI_H_
#define TSI_H_

#include "pt60_tower.h"
/******************************************************************************
* Includes
******************************************************************************/

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros
******************************************************************************/
// define TSI work mode
#define TSI_WORK_MODE_POLLING		1
#define TSI_WORK_MODE_INTERRUPT		2
#define TSI_WORK_MODE_STOP			3
#define TSI_WORK_MODE				TSI_WORK_MODE_STOP

#define EVB_BOARD				0x00
#define TOWER_BOARD				0x01

#ifdef TWR_PT60
	#define BOARD_TYPE			TOWER_BOARD
#else
	#define BOARD_TYPE			EVB_BOARD
#endif

#if( BOARD_TYPE == TOWER_BOARD )

#define TSI_PEN0_VALUE		0x03
#define TSI_PEN1_VALUE		0xc0


#elif( BOARD_TYPE == EVB_BOARD )
#define TSI_PEN0_VALUE		0x0f
#define TSI_PEN1_VALUE		0x00
#endif

//TSI idle exceed this time,will enter into stop mode
#define TSI_IDLE_TIME		5 //unit is s
                                      
/* define prescaler of the output electrode oscillator */
#define TSI_CS1_PS_1		(0)
#define TSI_CS1_PS_2		(1)
#define TSI_CS1_PS_4        (2)
#define TSI_CS1_PS_8       	(3)
#define TSI_CS1_PS_16       (4)
#define TSI_CS1_PS_32       (5)
#define TSI_CS1_PS_64      	(6)
#define TSI_CS1_PS_128     	(7)

/* define the scan number for each electrode */
#define TSI_CS1_NSCN_1		0
#define TSI_CS1_NSCN_2		1
#define TSI_CS1_NSCN_3		2
#define TSI_CS1_NSCN_4		3
#define TSI_CS1_NSCN_5		4
#define TSI_CS1_NSCN_6		5
#define TSI_CS1_NSCN_7		6
#define TSI_CS1_NSCN_8		7
#define TSI_CS1_NSCN_9		8
#define TSI_CS1_NSCN_10		9
#define TSI_CS1_NSCN_11		10
#define TSI_CS1_NSCN_12		11
#define TSI_CS1_NSCN_13		12
#define TSI_CS1_NSCN_14		13
#define TSI_CS1_NSCN_15		14
#define TSI_CS1_NSCN_16		15
#define TSI_CS1_NSCN_17		16
#define TSI_CS1_NSCN_18		17
#define TSI_CS1_NSCN_19		18
#define TSI_CS1_NSCN_20		19
#define TSI_CS1_NSCN_21		20
#define TSI_CS1_NSCN_22		21
#define TSI_CS1_NSCN_23		22
#define TSI_CS1_NSCN_24		23
#define TSI_CS1_NSCN_25		24
#define TSI_CS1_NSCN_26		25
#define TSI_CS1_NSCN_27		26
#define TSI_CS1_NSCN_28		27
#define TSI_CS1_NSCN_29		28
#define TSI_CS1_NSCN_30		29
#define TSI_CS1_NSCN_31		30
#define TSI_CS1_NSCN_32		31

/* define the reference oscillator charge current */
#define TSI_CS2_REFCHRG_500nA		(0)<<5
#define TSI_CS2_REFCHRG_1uA			(1)<<5
#define TSI_CS2_REFCHRG_2uA			(2)<<5
#define TSI_CS2_REFCHRG_4uA			(3)<<5 
#define TSI_CS2_REFCHRG_8uA			(4)<<5 
#define TSI_CS2_REFCHRG_16uA		(5)<<5
#define TSI_CS2_REFCHRG_32uA		(6)<<5
#define TSI_CS2_REFCHRG_64uA		(7)<<5

/* define the oscillator's voltage rails */
#define TSI_CS2_DVOLT_00			(0)<<3
#define TSI_CS2_DVOLT_01			(1)<<3
#define TSI_CS2_DVOLT_10			(2)<<3
#define TSI_CS2_DVOLT_11			(3)<<3

/* define the extern oscillator charge current */
#define TSI_CS2_EXTCHRG_500nA		(0)
#define TSI_CS2_EXTCHRG_1uA			(1)
#define TSI_CS2_EXTCHRG_2uA			(2)
#define TSI_CS2_EXTCHRG_4uA			(3) 
#define TSI_CS2_EXTCHRG_8uA			(4) 
#define TSI_CS2_EXTCHRG_16uA		(5)
#define TSI_CS2_EXTCHRG_32uA		(6)
#define TSI_CS2_EXTCHRG_64uA		(7)

#define true						1
#define false						0

//define key parameter
#define ELECTRODE_NUM				4
#define KEY_OVERTIME				2
#define KEY_ON_SENSITIVITY			2000u
#define KEY_OFF_SENSITIVITY			100u

// deine Key state
#define KEY_RELEASED				0x00
#define KEY_TOUCHED					0x01

//define TSI work state,
#define TSI_WORK_STATE_NULL			0x00
#define TSI_WORK_STATE_NORMAL		0x10

//define key check mode
#define KEY_CHECK_MODE_NORMAL		0x00
#define KEY_CHECK_MODE_STANDBY		0x01



/******************************************************************************
* Types
******************************************************************************/
typedef struct
{
	unsigned short MinValue;
	unsigned short MaxValue;
	unsigned short Average;
	unsigned short Delta;
}ELECTRODE_CHECK_INFO;

typedef struct
{
	unsigned short BaseLine;
	short Delta;
	unsigned char  Channel;
	unsigned char  Count;
	unsigned char  State;
}ELECTRODE_WORK_INFO;

/******************************************************************************
* Global variables
******************************************************************************/
extern unsigned char g_KeyCheckMode;
/******************************************************************************
* Global functions
******************************************************************************/
extern void TSI_Init( void );
extern void TSI_Processing( void );
extern void KEY1_Processing( void );
extern void KEY2_Processing( void );
extern void KEY3_Processing( void );
extern void KEY4_Processing( void );
extern void TSI_Check( void );
extern void TSI_EnterIntoStopMode( void );
extern void MCU_EnterStopMode( void );
#endif /* TSI_H_ */
