
/*******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       ADC12.c               											
*														              					
* Description:	  12-bit ADC Driver file for 9S08LL64	        	    	  	       						
*																						
* Notes:        																		
******************************************************************************/		
/* function prototypes */
void ADC_Init(unsigned char CONFIG1, unsigned char CONFIG2, 
              unsigned char STATUS2, unsigned char STATUS3, 
              unsigned char STATUS1) ;

/* include files */
#include "ADC12.h"    
#include "derivative.h" /* include peripheral declarations */

/******************************************************************************
Function Name	:	ADC_Init
Engineer      :	
Date          :	04/08/08

Parameters		:	
Returns			  :	NONE
Notes         : Initialises ADC (includes Calibration)
******************************************************************************/
              
void ADC_Init(unsigned char CONFIG1, unsigned char CONFIG2, unsigned char STATUS2, unsigned char STATUS3, unsigned char STATUS1)
{
  ADC_Config(CONFIG1, CONFIG2, STATUS2, STATUS3, STATUS1);
}

/******************************************************************************
Function Name   :       ADC_Config
Engineer      : 
Date          : 04/08/08

Parameters              :       
Returns                   :     NONE
Notes         : Configures ADC
******************************************************************************/
void ADC_Config(unsigned char CONFIG1, unsigned char CONFIG2, unsigned char STATUS2, unsigned char STATUS3, unsigned char STATUS1)
{
  ADCCFG1 = CONFIG1;
  ADCCFG2 = CONFIG2;
  ADCSC1 = STATUS1;       /* Leave ADCH = 0x1F */
  ADCSC2 = STATUS2;
  ADCSC3 = STATUS3;
}
 
              
              

