/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : BUZZER.H
**     Project   : PE_LL64_Demo
**     Processor : MC9S08LL64C_LQFP80
**     Beantype  : PWM
**     Version   : Bean 02.207, Driver 01.23, CPU db: 3.00.018
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 8/14/2009, 5:48 PM
**     Abstract  :
**         This bean implements a pulse-width modulation generator
**         that generates signal with variable duty and fixed cycle. 
**     Settings  :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       41            |  PTC2_TPM1CH0
**             ----------------------------------------------------
**
**         Timer name                  : TPM1 [16-bit]
**         Counter                     : TPM1CNT   [$0041]
**         Mode register               : TPM1SC    [$0040]
**         Run register                : TPM1SC    [$0040]
**         Prescaler                   : TPM1SC    [$0040]
**         Compare register            : TPM1C0V   [$0046]
**         Flip-flop register          : TPM1C0SC  [$0045]
**
**         Interrupt name              : Vtpm1ch0
**         Interrupt enable reg.       : TPM1C0SC  [$0045]
**         Priority                    : 
**         User handling procedure     : BUZZER_OnEnd
**         This event is called when the 1 of cycles is generated
**
**         Port name                   : PTC
**         Bit number (in port)        : 2
**         Bit mask of the port        : $0004
**         Port data register          : PTCD      [$0004]
**         Port control register       : PTCDD     [$0005]
**
**         Initialization:
**              Output level           : low
**              Timer                  : Enabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 9961472 Hz
**           Initial value of            period     pulse width
**             Xtal ticks              : 26         26
**             microseconds            : 800        800
**             milliseconds            : 1          1
**             seconds (real)          : 0.000799982171 0.000799982171
**
**     Contents  :
**         SetRatio16 - byte BUZZER_SetRatio16(word Ratio);
**         SetDutyUS  - byte BUZZER_SetDutyUS(word Time);
**         SetDutyMS  - byte BUZZER_SetDutyMS(word Time);
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __BUZZER
#define __BUZZER

/* MODULE BUZZER. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PE_Timer.h"
#include "Cpu.h"

#define BUZZER_PERIOD_VALUE              0x1F20 /* Initial period value in ticks of the timer in high speed mode */
#define BUZZER_PERIOD_VALUE_HIGH         0x1F20 /* Period value in ticks of the timer in high speed mode */

#pragma CODE_SEG BUZZER_CODE

byte BUZZER_SetRatio16(word Ratio);
/*
** ===================================================================
**     Method      :  BUZZER_SetRatio16 (bean PWM)
**
**     Description :
**         This method sets a new duty-cycle ratio.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Ratio      - Ratio is expressed as an 16-bit unsigned integer
**                      number. 0 - 0xFFFF value is proportional
**                      to ratio 0 - 100%
**         Note: Calculated duty depends on the timer possibilities
**               and on the selected period.
**     Returns     :
**         ---        - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte BUZZER_SetDutyUS(word Time);
/*
** ===================================================================
**     Method      :  BUZZER_SetDutyUS (bean PWM)
**
**     Description :
**         This method sets the new duty value of the output signal.
**         The duty is expressed in microseconds as a 16-bit
**         unsigned integer number.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Time            - Duty to set [in microseconds]
**                      (0 to 800 us in high speed mode)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

byte BUZZER_SetDutyMS(word Time);
/*
** ===================================================================
**     Method      :  BUZZER_SetDutyMS (bean PWM)
**
**     Description :
**         This method sets the new duty value of the output signal.
**         The duty is expressed in milliseconds as a 16-bit
**         unsigned integer number.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Time            - Duty to set [in milliseconds]
**                      (0 to 1 ms in high speed mode)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

void BUZZER_Init(void);
/*
** ===================================================================
**     Method      :  BUZZER_Init (bean PWM)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#pragma CODE_SEG __NEAR_SEG NON_BANKED
__interrupt void BUZZER_Interrupt(void);
#pragma CODE_SEG BUZZER_CODE
/*
** ===================================================================
**     Method      :  BUZZER_Interrupt (bean PWM)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma CODE_SEG DEFAULT

/* END BUZZER. */

#endif /* ifndef __BUZZER */
/*
** ###################################################################
**
**     This file was created by Processor Expert 3.06 [04.26]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
