/*^^^^^^^^^^^^^^^^      LCD Configuration                        ^^^^^^^^^^^^^^^^^^^^^^^^*/
#define _LCDBACKPLANES                  (8)   // # of backplanes  

#define _LCDCLKPSL                      (4)   //  Clock divider to generate the LCD Waveforms


#define _LCDCPSEL                       (1)   //0 -- Resistor network   1 -- Charge pump  
#define _LCDVSUPPLY                     (3)   //0  --  VLL2 from VDD    1 --   VLL3 from VDD  2 -- VLL1 from VLCD  3 -- VLL3 external or from VIREG

#define _LCDLOADADJUST                  (0)   //Charge Pump (CPSEL = 1) 0 -- 8000 pf 1 -- 6000 pf  2 -- 4000 pf  3 -- 2000 pf
                                              //Resistor network        0 -- 2000 pf 1 -- 2000 pf  2 -- 8000 pf   3 -- 8000 pf 

#define _LCDFRAMEINTERRUPT              (0)   //0 Disabel  Interrupt 1 Enable aLCD interrupt that coincides with the LCD frame frequency

#define _LCDBLINKRATE                   (0)   //Blink frequecy preescaler  any number between 0-7

/*^^^^^^^^^^^^^^^^      LCD Hardware Connection 			 ^^^^^^^^^^^^^^^^^^^^^^^^*/
#define _CHARNUM     (9)                                                                               // Number of characters on the display
#define _LCDTYPE     (2)                                                                                //Number of LCDWF  nedded  to drive one character 

#define EnableLCDpins(RegNum,Mask)		    LCDPEN##RegNum = Mask
#define  EnableBackplane(RegNum, LCDn)	  LCDBPEN##RegNum##_BPEN##LCDn  = 1    
#define  SetBackplane(ComNum, LCDn)		    LCDWF##LCDn  = (1 <<  (##ComNum##))
#define CharacterPlace(LCDn)        			LCDWF##LCDn
#define MapSegment(BitNumber)  			      (1<<(##BitNumber##)) 
#define SymbolON(LCDn,Mask)	              LCDWF##LCDn   |=  (1<<(Mask))
#define SymbolOFF(LCDn,Mask)	            LCDWF##LCDn   &=  ~(1<<(Mask))
#define SymbolBlink(LCDn, BitNumber)      LCDWF##LCDn   ^=  (1<<BitNumber)

/*Habilitate the mcu pin with the characteristics of a LCD pin 
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number  that its connected example */
#define PinEnable0       EnableLCDpins (0,255)
#define PinEnable1       EnableLCDpins (1,255)
#define PinEnable2       EnableLCDpins (2,255)
//#define PinEnable3       EnableLCDpins (3,255)
#define PinEnable3       EnableLCDpins (3,255)

/* Enable the LCD pin like a Backplane functionality  
param: RegNum -- Number of register to write     LCDpin --- LCDn pin number that the Backplane it's connected */
	#define   EnableCom1        EnableBackplane (0, 0)
	#define   EnableCom2        EnableBackplane (0, 1)
	#define   EnableCom3        EnableBackplane (0, 2)
	#define   EnableCom4        EnableBackplane (0, 3)
	#define   EnableCom5        EnableBackplane (0, 4)
	#define   EnableCom6        EnableBackplane (0, 5)
	#define   EnableCom7        EnableBackplane (0, 6)
	#define   EnableCom8        EnableBackplane (0, 7)

/* Give the mask to the Backplane     
param: ComNum -- COM number     LCDpin --- LCDn number of pin that its connected example */
	#define   SetCom1        SetBackplane (0, 0)
	#define   SetCom2        SetBackplane (1, 1)
	#define   SetCom3        SetBackplane (2, 2)
	#define   SetCom4        SetBackplane (3, 3)
	#define   SetCom5        SetBackplane (4, 4)
	#define   SetCom6        SetBackplane (5, 5)
	#define   SetCom7        SetBackplane (6, 6)
	#define   SetCom8        SetBackplane (7, 7)

/* This macro defines the LDCWavefroms directions needed to write the Characters      
param:  LCDpin --- LCDn number of pin that its connected */
	#define   Char1a        CharacterPlace (9)  // LCD Pin 10
	#define   Char1b        CharacterPlace (8)  // LCD Pin 9
	#define   Char2a        CharacterPlace (11)  // LCD Pin 12
	#define   Char2b        CharacterPlace (10)  // LCD Pin 11
	#define   Char3a        CharacterPlace (13)  // LCD Pin 14
	#define   Char3b        CharacterPlace (12)  // LCD Pin 13
	#define   Char4a        CharacterPlace (15)  // LCD Pin 16
	#define   Char4b        CharacterPlace (14)  // LCD Pin 15
	#define   Char5a        CharacterPlace (18)  // LCD Pin 30
	#define   Char5b        CharacterPlace (17)  // LCD Pin 31
	#define   Char6a        CharacterPlace (20)  // LCD Pin 28
	#define   Char6b        CharacterPlace (19)  // LCD Pin 29
	#define   Char7a        CharacterPlace (22)  // LCD Pin 26
	#define   Char7b        CharacterPlace (21)  // LCD Pin 27
	#define   Char8a        CharacterPlace (24)  // LCD Pin 24
	#define   Char8b        CharacterPlace (23)  // LCD Pin 25
	#define   Char9a        CharacterPlace (26)  // LCD Pin 22
	#define   Char9b        CharacterPlace (25)  // LCD Pin 23

/* Turns on the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol */
	#define _LCD_PROGRAM_ON SymbolON(31,0)
	#define _LCD_MODE_ON SymbolON(31,1)
	#define _LCD_CONTRAST_ON SymbolON(31,2)
	#define _LCD_VOLUME_ON SymbolON(31,3)
	#define _LCD_DT3_ON SymbolON(31,4)
	#define _LCD_COL2_ON SymbolON(31,5)
	#define _LCD_DT4_ON SymbolON(31,6)
	#define _LCD_DT5_ON SymbolON(31,7)
	#define _LCD_PM_ON SymbolON(30,0)
	#define _LCD_AM_ON SymbolON(30,1)
	#define _LCD_KWH_ON SymbolON(30,2)
	#define _LCD_VOL1_ON SymbolON(30,3)
	#define _LCD_VOL2_ON SymbolON(30,4)
	#define _LCD_VOL3_ON SymbolON(30,5)
	#define _LCD_VOL4_ON SymbolON(30,6)
	#define _LCD_VOL5_ON SymbolON(30,7)
	#define _LCD_COL4_ON SymbolON(29,0)
	#define _LCD_POWER_ON SymbolON(29,1)
	#define _LCD_VOL_ON SymbolON(29,2)
	#define _LCD_BATTERY_ON SymbolON(29,3)
	#define _LCD_BAT4_ON SymbolON(29,4)
	#define _LCD_BAT3_ON SymbolON(29,5)
	#define _LCD_BAT2_ON SymbolON(29,6)
	#define _LCD_BAT1_ON SymbolON(29,7)
	#define _LCD_M5_ON SymbolON(28,0)
	#define _LCD_M4_ON SymbolON(28,1)
	#define _LCD_M3_ON SymbolON(28,2)
	#define _LCD_M2_ON SymbolON(28,3)
	#define _LCD_M1_ON SymbolON(28,4)
	#define _LCD_M8_ON SymbolON(28,5)
	#define _LCD_M7_ON SymbolON(28,6)
	#define _LCD_M6_ON SymbolON(28,7)
	#define _LCD_AMPS_ON SymbolON(27,0)
	#define _LCD_VOLTS_ON SymbolON(27,1)
	#define _LCD_OHMS_ON SymbolON(27,2)
	#define _LCD_DT6_ON SymbolON(27,3)
	#define _LCD_COL3_ON SymbolON(27,4)
	#define _LCD_DT8_ON SymbolON(27,5)
	#define _LCD_DT7_ON SymbolON(27,6)
	#define _LCD_CLOCK_ON SymbolON(27,7)
	#define _LCD_FREESCALE_ON SymbolON(16,0)
	#define _LCD_MINUS_ON SymbolON(16,1)
	#define _LCD_TIME_ON SymbolON(16,2)
	#define _LCD_DATE_ON SymbolON(16,3)
	#define _LCD_TEMP_ON SymbolON(16,4)
	#define _LCD_COL1_ON SymbolON(16,5)
	#define _LCD_DT1_ON SymbolON(16,6)
	#define _LCD_DT2_ON SymbolON(16,7)

/* Turns off the  segment   that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns off that Symbol */
	#define   _LCD_PROGRAM_OFF SymbolOFF(31,0)
	#define   _LCD_MODE_OFF SymbolOFF(31,1)
	#define   _LCD_CONTRAST_OFF SymbolOFF(31,2)
	#define   _LCD_VOLUME_OFF SymbolOFF(31,3)
	#define   _LCD_DT3_OFF SymbolOFF(31,4)
	#define   _LCD_COL2_OFF SymbolOFF(31,5)
	#define   _LCD_DT4_OFF SymbolOFF(31,6)
	#define   _LCD_DT5_OFF SymbolOFF(31,7)
	#define   _LCD_PM_OFF SymbolOFF(30,0)
	#define   _LCD_AM_OFF SymbolOFF(30,1)
	#define   _LCD_KWH_OFF SymbolOFF(30,2)
	#define   _LCD_VOL1_OFF SymbolOFF(30,3)
	#define   _LCD_VOL2_OFF SymbolOFF(30,4)
	#define   _LCD_VOL3_OFF SymbolOFF(30,5)
	#define   _LCD_VOL4_OFF SymbolOFF(30,6)
	#define   _LCD_VOL5_OFF SymbolOFF(30,7)
	#define   _LCD_COL4_OFF SymbolOFF(29,0)
	#define   _LCD_POWER_OFF SymbolOFF(29,1)
	#define   _LCD_VOL_OFF SymbolOFF(29,2)
	#define   _LCD_BATTERY_OFF SymbolOFF(29,3)
	#define   _LCD_BAT4_OFF SymbolOFF(29,4)
	#define   _LCD_BAT3_OFF SymbolOFF(29,5)
	#define   _LCD_BAT2_OFF SymbolOFF(29,6)
	#define   _LCD_BAT1_OFF SymbolOFF(29,7)
	#define   _LCD_M5_OFF SymbolOFF(28,0)
	#define   _LCD_M4_OFF SymbolOFF(28,1)
	#define   _LCD_M3_OFF SymbolOFF(28,2)
	#define   _LCD_M2_OFF SymbolOFF(28,3)
	#define   _LCD_M1_OFF SymbolOFF(28,4)
	#define   _LCD_M8_OFF SymbolOFF(28,5)
	#define   _LCD_M7_OFF SymbolOFF(28,6)
	#define   _LCD_M6_OFF SymbolOFF(28,7)
	#define   _LCD_AMPS_OFF SymbolOFF(27,0)
	#define   _LCD_VOLTS_OFF SymbolOFF(27,1)
	#define   _LCD_OHMS_OFF SymbolOFF(27,2)
	#define   _LCD_DT8_OFF SymbolOFF(27,3)
	#define   _LCD_COL3_OFF SymbolOFF(27,4)
	#define   _LCD_DT6_OFF SymbolOFF(27,5)
	#define   _LCD_DT7_OFF SymbolOFF(27,6)
	#define   _LCD_CLOCK_OFF SymbolOFF(27,7)
	#define   _LCD_FREESCALE_OFF SymbolOFF(16,0)
	#define   _LCD_MINUS_OFF SymbolOFF(16,1)
	#define   _LCD_TIME_OFF SymbolOFF(16,2)
	#define   _LCD_DATE_OFF SymbolOFF(16,3)
	#define   _LCD_TEMP_OFF SymbolOFF(16,4)
	#define   _LCD_COL1_OFF SymbolOFF(16,5)
	#define   _LCD_DT1_OFF SymbolOFF(16,6)
	#define   _LCD_DT2_OFF SymbolOFF(16,7)
	
	/* Blinks the  segment that its dedicated to write one Symbol     
param:  LCDpin --- LCDn number of pin that its connected   BitNumber -- COM Number that turns on that Symbol */
	#define _LCD_PROGRAM_Blink    SymbolBlink(31,0)
	#define _LCD_MODE_Blink       SymbolBlink(31,1)
	#define _LCD_CONTRAST_Blink   SymbolBlink(31,2)
	#define _LCD_VOLUME_Blink     SymbolBlink(31,3)
	#define _LCD_DT3_Blink        SymbolBlink(31,4)
	#define _LCD_COL2_Blink       SymbolBlink(31,5)
	#define _LCD_DT4_Blink        SymbolBlink(31,6)
	#define _LCD_DT5_Blink        SymbolBlink(31,7)
	#define _LCD_PM_Blink         SymbolBlink(30,0)
	#define _LCD_AM_Blink         SymbolBlink(30,1)
	#define _LCD_KWH_Blink        SymbolBlink(30,2)
	#define _LCD_VOL1_Blink       SymbolBlink(30,3)
	#define _LCD_VOL2_Blink       SymbolBlink(30,4)
	#define _LCD_VOL3_Blink       SymbolBlink(30,5)
	#define _LCD_VOL4_Blink       SymbolBlink(30,6)
	#define _LCD_VOL5_Blink       SymbolBlink(30,7)
	#define _LCD_COL4_Blink       SymbolBlink(29,0)
	#define _LCD_POWER_Blink      SymbolBlink(29,1)
	#define _LCD_VOL_Blink        SymbolBlink(29,2)
	#define _LCD_BATTERY_Blink    SymbolBlink(29,3)
	#define _LCD_BAT4_Blink       SymbolBlink(29,4)
	#define _LCD_BAT3_Blink       SymbolBlink(29,5)
	#define _LCD_BAT2_Blink       SymbolBlink(29,6)
	#define _LCD_BAT1_Blink       SymbolBlink(29,7)
	#define _LCD_M5_Blink         SymbolBlink(28,0)
	#define _LCD_M4_Blink         SymbolBlink(28,1)
	#define _LCD_M3_Blink         SymbolBlink(28,2)
	#define _LCD_M2_Blink         SymbolBlink(28,3)
	#define _LCD_M1_Blink         SymbolBlink(28,4)
	#define _LCD_M8_Blink         SymbolBlink(28,5)
	#define _LCD_M7_Blink         SymbolBlink(28,6)
	#define _LCD_M6_Blink         SymbolBlink(28,7)
	#define _LCD_AMPS_Blink       SymbolBlink(27,0)
	#define _LCD_VOLTS_Blink      SymbolBlink(27,1)
	#define _LCD_OHMS_Blink       SymbolBlink(27,2)
	#define _LCD_DT6_Blink        SymbolBlink(27,3)
	#define _LCD_COL3_Blink       SymbolBlink(27,4)
	#define _LCD_DT8_Blink        SymbolBlink(27,5)
	#define _LCD_DT7_Blink        SymbolBlink(27,6)
	#define _LCD_CLOCK_Blink      SymbolBlink(27,7)
	#define _LCD_FREESCALE_Blink  SymbolBlink(16,0)
	#define _LCD_MINUS_Blink      SymbolBlink(16,1)
	#define _LCD_TIME_Blink       SymbolBlink(16,2)
	#define _LCD_DATE_Blink       SymbolBlink(16,3)
	#define _LCD_TEMP_Blink       SymbolBlink(16,4)
	#define _LCD_COL1_Blink       SymbolBlink(16,5)
	#define _LCD_DT1_Blink        SymbolBlink(16,6)
	#define _LCD_DT2_Blink        SymbolBlink(16,7)

/*Give the apropiate mask to set one segment of the display
param: BitNumber  -- Number of bit that needs to be turn on*/ 
#define  SEG1         MapSegment (0)
#define  SEG2         MapSegment (1)
#define  SEG3         MapSegment (2)
#define  SEG4         MapSegment (3)
#define  SEG5         MapSegment (4)
#define  SEG6         MapSegment (5)
#define  SEG7         MapSegment (6)
#define  SEG8         MapSegment (7)
          
#define SEGP        SEG1
#define SEGB        SEG2
#define SEGK        SEG3
#define SEGG        SEG4
#define SEGC        SEG5
#define SEGI          SEG6
#define SEGM        SEG7
#define SEGD        SEG8
#define SEGA        SEG1
#define SEGF         SEG2
#define SEGH        SEG3
#define SEGJ         SEG4
#define SEGL         SEG5
#define SEGE        SEG6
#define SEGN        SEG7
#define SEGO        SEG8

#define WF8_ON         LCDWF8= 255
#define WF9_ON         LCDWF9= 255
#define WF10_ON       LCDWF10= 255
#define WF11_ON       LCDWF11= 255
#define WF12_ON       LCDWF12= 255
#define WF13_ON       LCDWF13= 255
#define WF14_ON       LCDWF14= 255
#define WF15_ON       LCDWF15= 255
#define WF31_ON       LCDWF31= 255
#define WF30_ON       LCDWF30= 255
#define WF29_ON       LCDWF29= 255
#define WF28_ON       LCDWF28= 255
#define WF27_ON       LCDWF27= 255
#define WF26_ON       LCDWF26= 255
#define WF25_ON       LCDWF25= 255
#define WF24_ON       LCDWF24= 255
#define WF23_ON       LCDWF23= 255
#define WF22_ON       LCDWF22= 255
#define WF21_ON       LCDWF21= 255
#define WF20_ON       LCDWF20= 255
#define WF19_ON       LCDWF19= 255
#define WF18_ON       LCDWF18= 255
#define WF17_ON       LCDWF17= 255
#define WF16_ON       LCDWF16= 255

#define WF8_OFF         LCDWF8= 0
#define WF9_OFF         LCDWF9= 0
#define WF10_OFF       LCDWF10= 0
#define WF11_OFF       LCDWF11= 0
#define WF12_OFF       LCDWF12= 0
#define WF13_OFF       LCDWF13= 0
#define WF14_OFF       LCDWF14= 0
#define WF15_OFF       LCDWF15= 0
#define WF31_OFF       LCDWF31= 0
#define WF30_OFF       LCDWF30= 0
#define WF29_OFF       LCDWF29= 0
#define WF28_OFF       LCDWF28= 0
#define WF27_OFF       LCDWF27= 0
#define WF26_OFF       LCDWF26= 0
#define WF25_OFF       LCDWF25= 0
#define WF24_OFF       LCDWF24= 0
#define WF23_OFF       LCDWF23= 0
#define WF22_OFF       LCDWF22= 0
#define WF21_OFF       LCDWF21= 0
#define WF20_OFF       LCDWF20= 0
#define WF19_OFF       LCDWF19= 0
#define WF18_OFF       LCDWF18= 0
#define WF17_OFF       LCDWF17= 0
#define WF16_OFF       LCDWF16= 0



//Ascii table American Standar
#define _ALLON         (SEGP+SEGB+SEGK+SEGG+SEGC+SEGI+SEGM+SEGD)
#define _ALLOFF         (0);     
#define  _0a		(SEGP+SEGB+SEGC+SEGD)
#define _0b		(SEGO+SEGE+SEGF+SEGA)
#define _1a		(SEGB + SEGC)
#define _1b		(0)
#define _2a		(SEGP+SEGB+SEGG+SEGD)
#define _2b		(SEGA+SEGL+SEGE+SEGO)
#define _3a		(SEGP+SEGB+SEGG+SEGC+SEGD)
#define _3b		(SEGA+SEGO+SEGL)
#define _4a		(SEGB+SEGG+SEGC)
#define _4b		(SEGF+SEGL)
#define _5a		(SEGP+SEGG+SEGC+SEGD)
#define _5b		(SEGA+SEGF+SEGL+SEGO)
#define _6a		(SEGG+SEGC+SEGD)
#define _6b		(SEGF+SEGL+SEGE+SEGO)
#define _7a		(SEGP+SEGB+SEGC)
#define _7b		(SEGA)
#define _8a 		(SEGP+SEGB+SEGG+SEGC+SEGD)
#define _8b		(SEGA+SEGF+SEGL+SEGE+SEGO)
#define _9a		(SEGP+SEGB+SEGG+SEGC)
#define _9b		(SEGA+SEGF+SEGL)
#define _a2Points	(0)
#define _b2Points	(0)
#define _aSemicolon	(SEGG+SEGI)
#define _bSemicolon	(0)
#define _aMinusThat	(SEGK+SEGI)
#define _bMinusThat	(0)
#define _aEqual	(SEGP+SEGG)
#define _bEqual	(SEGA+SEGL)
#define _aMajorThat 	(0)
#define _bMajorThat	(SEGH+SEGN)
#define _aQuestion	(SEGP+SEGB+SEGG)
#define _bQuestion	(SEGA+SEGE+SEGL)
#define _Aa		(SEGP+SEGB+SEGG+SEGC)
#define _Ab		(SEGA+SEGF+SEGL+SEGE)
#define _Ba 		(SEGP+SEGB+SEGC+SEGD+SEGG)
#define _Bb		(SEGA+SEGF+SEGL+SEGE+SEGO)
#define _Ca		(SEGP+SEGD)
#define _Cb		(SEGA+SEGF+SEGE+SEGO)
#define _Da		(SEGP+SEGB+SEGC+SEGD)
#define _Db		(SEGA+SEGF+SEGE+SEGO)
#define _Ea		(SEGP+SEGG+SEGD)
#define _Eb		(SEGA+SEGF+SEGE+SEGL+SEGO)
#define _Fa 		(SEGP+SEGG)
#define _Fb		(SEGA+SEGF+SEGE+SEGL)
#define _Ga		(SEGP+SEGG+SEGC+SEGD)
#define _Gb 		(SEGA+SEGF+SEGL+SEGE+SEGO)
#define _Ha		(SEGB+SEGG+SEGC)
#define _Hb		(SEGF+SEGL+SEGE)
#define _Ia		(SEGM)
#define _Ib		(SEGJ)
#define _Ja		(SEGB+SEGC+SEGD)
#define _Jb 		(SEGO)
#define _Ka		(SEGK+SEGG+SEGI)
#define _Kb		(SEGF+SEGL+SEGE)
#define _La		(SEGD)
#define _Lb		(SEGF+SEGE+SEGO)
#define _Ma		(SEGK+SEGB+SEGC)
#define _Mb		(SEGF+SEGH+SEGE)
#define _Na		(SEGB+SEGI+SEGC)
#define _Nb		(SEGF+SEGH+SEGE)
#define _Oa		(SEGP+SEGB+SEGC+SEGD)
#define _Ob		(SEGA+SEGF+SEGE+SEGO)
#define _Pa		(SEGP+SEGB+SEGG)
#define _Pb		(SEGA+SEGF+SEGL+SEGE)
#define _Qa 		(SEGP+SEGB+SEGG+SEGC+SEGD)
#define _Qb		(SEGA+SEGF+SEGL+SEGE+SEGO)
#define _Ra		(SEGP+SEGB+SEGG+SEGI)
#define _Rb		(SEGA+SEGF+SEGL+SEGE)
#define _Sa		(SEGP+SEGG+SEGC+SEGD)
#define _Sb		(SEGA+SEGF+SEGL+SEGO)
#define _Ta		(SEGP+SEGM)
#define _Tb		(SEGA+SEGJ)
#define _Ua		(SEGB+SEGC+SEGD)
#define _Ub		(SEGF+SEGE+SEGO)
#define _Va		(SEGI+SEGC+SEGB)
#define _Vb		(SEGH)
#define _Wa		(SEGB+SEGC+SEGM+SEGD)
#define _Wb		(SEGF+SEGJ+SEGE+SEGO)
#define _Xa		(SEGK+SEGI)
#define _Xb		(SEGH+SEGN)
#define _Ya		(SEGK+SEGM)
#define _Yb		(SEGH)
#define _Za		(SEGP+SEGB+SEGG+SEGD)
#define _Zb	  (SEGN+SEGO+SEGA)
#define _aDegrees (SEGP+SEGB+SEGG)
#define _bDegrees (SEGA+SEGL+SEGF)

