#ifndef __ADC__
#define __ADC__

#include "derivative.h" /* include peripheral declarations */
#include "FslTypes.h"

#ifndef TOTAL_ADCs

  #define TOTAL_ADCs           1

  #if (TOTAL_ADCs >= 1)
    #define ADC1_CHAN_MASK     (1<<6)
    #define ADC1_CHAN          6
    #define ADC1_PCTL1         APCTL1_ADPC6_MASK
    #define ADC1_PCTL2         0
    #define ADC1_PCTL3         0
  #endif
  
  #if (TOTAL_ADCs >= 2)
    #define ADC2_CHAN_MASK     (1<<6)
    #define ADC2_CHAN          27
    #define ADC2_PCTL1         0 
    #define ADC2_PCTL2         0
    #define ADC2_PCTL3         0
  #else
    #define ADC2_PCTL1         0
    #define ADC2_PCTL2         0
    #define ADC2_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 3)
    #define ADC3_CHAN_MASK    
    #define ADC3_CHAN         
    #define ADC3_PCTL1         0
    #define ADC3_PCTL2         0
    #define ADC3_PCTL3         0
  #else
    #define ADC3_PCTL1         0
    #define ADC3_PCTL2         0
    #define ADC3_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 4)
    #define ADC4_CHAN_MASK    
    #define ADC4_CHAN         
    #define ADC4_PCTL1         0
    #define ADC4_PCTL2         0
    #define ADC4_PCTL3         0
  #else
    #define ADC4_PCTL1         0
    #define ADC4_PCTL2         0
    #define ADC4_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 5)
    #define ADC5_CHAN_MASK    
    #define ADC5_CHAN         
    #define ADC5_PCTL1         0
    #define ADC5_PCTL2         0
    #define ADC5_PCTL3         0
  #else
    #define ADC5_PCTL1         0
    #define ADC5_PCTL2         0
    #define ADC5_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 6)
    #define ADC6_CHAN_MASK    
    #define ADC6_CHAN         
    #define ADC6_PCTL1         0
    #define ADC6_PCTL2         0
    #define ADC6_PCTL3         0
  #else
    #define ADC6_PCTL1         0
    #define ADC6_PCTL2         0
    #define ADC6_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 7)
    #define ADC7_CHAN_MASK    
    #define ADC7_CHAN         
    #define ADC7_PCTL1         0
    #define ADC7_PCTL2         0
    #define ADC7_PCTL3         0
  #else
    #define ADC7_PCTL1         0
    #define ADC7_PCTL2         0
    #define ADC7_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 8)
    #define ADC8_CHAN_MASK    
    #define ADC8_CHAN         
    #define ADC8_PCTL1         0
    #define ADC8_PCTL2         0
    #define ADC8_PCTL3         0
  #else
    #define ADC8_PCTL1         0
    #define ADC8_PCTL2         0
    #define ADC8_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 9)
    #define ADC9_CHAN_MASK    
    #define ADC9_CHAN         
    #define ADC9_PCTL1         0
    #define ADC9_PCTL2         0
    #define ADC9_PCTL3         0
  #else
    #define ADC9_PCTL1         0
    #define ADC9_PCTL2         0
    #define ADC9_PCTL3         0
  #endif
  #if (TOTAL_ADCs >= 10)
    #define ADC10_CHAN_MASK    
    #define ADC10_CHAN         
    #define ADC10_PCTL1         0
    #define ADC10_PCTL2         0
    #define ADC10_PCTL3         0
  #else
    #define ADC10_PCTL1         0
    #define ADC10_PCTL2         0
    #define ADC10_PCTL3         0
  #endif

#define APCTL1_REG    ADC1_PCTL1 | ADC2_PCTL1 | ADC3_PCTL1 | ADC4_PCTL1 | ADC5_PCTL1 | ADC6_PCTL1 | ADC7_PCTL1 | ADC8_PCTL1 | ADC9_PCTL1 | ADC10_PCTL1;
#define APCTL2_REG    ADC1_PCTL2 | ADC2_PCTL2 | ADC3_PCTL2 | ADC4_PCTL2 | ADC5_PCTL2 | ADC6_PCTL2 | ADC7_PCTL2 | ADC8_PCTL2 | ADC9_PCTL2 | ADC10_PCTL2;
#define APCTL3_REG    ADC1_PCTL3 | ADC2_PCTL3 | ADC3_PCTL3 | ADC4_PCTL3 | ADC5_PCTL3 | ADC6_PCTL3 | ADC7_PCTL3 | ADC8_PCTL3 | ADC9_PCTL3 | ADC10_PCTL3;

#define ADC_ACTIVE_CONVERSION   ADCSC2_ADACT

#endif

#pragma DATA_SEG DEFAULT
#pragma DATA_SEG MY_ZEROPAGE
#if (TOTAL_ADCs > 0)
extern UINT16 near ADCTable[TOTAL_ADCs];
#else
extern UINT16 near ADCTable[1];
#endif
#pragma DATA_SEG DEFAULT


#define ADC_LowPower()          SCGC1_ADC = 0
#define ADC_WakeUp()            SCGC1_ADC = 1


void HWTrig_ADC_Init(UINT16* ADC_BufferPointer);

void ADC_Init(UINT16* ADC_BufferPointer);
  
void ADC_Start_conversion(UINT8);

void ADC_Start_conversions(void);

UINT16 ADC_Get_Conversion(void);

void ADC_End(void);

#endif