#ifndef __TEMP_MEASUREMENT__

  #define __TEMP_MEASUREMENT__
  
  #include <hidef.h>
  #include "derivative.h"
  #include "S08_ADC12.h"
  #include "TempControl.h"
    
  typedef enum
  {
    TEMP_MEASUREMENT_IDLE,
    TEMP_MEASUREMENT_GET_ADC_CONVERSIONS,
    GET_TEMPERATURE,
    TEMP_MEASUREMENT_GET_VDD
  }__TEMP_MEASUREMENT_SM_ENUM__;
  
  #define TEMPERATURE_MEASUREMENT_IDLE   sTempMeasurementSM.ActualState == TEMP_MEASUREMENT_IDLE
  
  #define _TEMPADC_SAMPLES_COUNT_        8
  #define TEMPERATURE_ERROR              0xffff;
  
  #define _TOTAL_METRIC_SYSTEMS_         2
  #define _CELSIUS_                      0
  #define _FAHRENHEIT_                   1
  
  #define CELSIUS_DEGREES_START          10
  #define FAHRENHEIT_DEGREES_START       50
  
  #define BANDGAP_VALUE                  117
  #define BANDGAP_CHANNEL                27
  #define THERMISTOR_CHAN                ADC1_CHAN
  #define THERMISTOR_ADC_PIN_ENABLE      APCTL1_ADPC0
  #define THERMISTOR_PIN_PULL_UP_ENABLE  PTAPE_PTAPE6 = 1
  #define TEMP_ADC_CONVERSION_READY()    (!ADC_ACTIVE_CONVERSION)
  #define TempADC_Start_conversion       ADC_Start_conversion
  
  #define DISABLE_TEMP_ADC_CHANNEL()     APCTL1 &= ~ADC1_PCTL1;\
                                         PTAD &= ~ (PTADD_PTADD6_MASK | PTADD_PTADD7_MASK);\
                                         PTADD |=  PTADD_PTADD6_MASK | PTADD_PTADD7_MASK;
                                         
                                         
  
  #define TempMeasurementInitADC()       PTAD_PTAD7 = 1;\
                                         PTADD_PTADD7 = 1;\
                                         ADC_Init((UINT16*)&gu16ADCTempChannel)
  #define TempMeasurementPollADC         ADC_Get_Conversion
  
  #define TEMP_MEASUREMENT_SET_STATE(x)  sTempMeasurementSM.ActualState = x
  #define TEMP_MEASUREMENT_NEXT_STATE(x) sTempMeasurementSM.NextState = x
  
  #define METRIC_SYSTEM_CELSIUS()        gu8TempMetricSystem == _CELSIUS_
  #define METRIC_SYSTEM_FAHRENHEIT()     gu8TempMetricSystem == _FAHRENHEIT_
  
  
  extern UINT16 gu16Temperature;
  extern UINT8  gu8TempMetricSystem;
  extern UINT16 gu16ADCVDD;
  extern sSM    sTempMeasurementSM;
  
  
  void vfnTempMeasurementStartConversion(void);
  void vfnTempMeasurement_Init(void);
  void vfnTempMeasurementSM(void);
  
  
#endif