#ifndef __TSTAT_LCD__
  #define __TSTAT_LCD__
  
  #include "FslTypes.h"
  #include "Thermostat_Definitions.h"
  #include "Calendar.h"
  #include "Ascii.h"
  #ifdef __LOWEND_TSTAT__
    #include "LCD_GD5360P.h"
  #else
    #include "LCD_GD4935.h"
  #endif  
  
  
  #define _LCD_BLANK_SPACE_     0x3A
  
  
  #ifdef __HIGHEND_TSTAT__
    #define _LCD_DEGREES_SYMBOL   0x40
  #else
    #define _LCD_DEGREES_SYMBOL   0x3F
  #endif
  
  /* Voltage leveles are in Volts * 10 */
  #define BATT_4_LEVEL_INDICATOR    280
  #define BATT_3_LEVEL_INDICATOR    270
  #define BATT_2_LEVEL_INDICATOR    260
  #define BATT_1_LEVEL_INDICATOR    240
  
  
  void vfnThermostatLCD_Init(void);
  void vfnDisplayDayOfWeek(UINT8 DayOfWeek);
  void vfnUpdateDayAndTime(RTC_Type* LocalRTC);
  void vfnDisplayBatteryLife(UINT16 BatteryLevel);
  void vfnDisplayTemperature(UINT16 Temperature);
  
  #ifdef __LOWEND_TSTAT__
    void vfnBlinkDayOfWeek(UINT8 DayOfWeek);
  #endif
  
#endif