/******************************************************************************
*                                             COPYRIGHT (c) Freescale 2007   
* FILE NAME: sci_drv.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: Driver files for SCI							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  
* ------------        
*
* Simple routines for outputing chars, strings and numbers to a terminal for 
* debugging purposes.
* PutChar is polled - compatible with a RAM target build.
* Output is not queued.
* Use these routines as an alternative to Printf type fuctions for a smaller
* embedded code footprint and execution time.                                                                          
*                                                                           
* AUTHOR: R28318        LOCATION: EKB         
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	R28318      08JAN07     Initial coding                                   
*                                                                    
*                                                                           
******************************************************************************/

/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Freescale does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Freescale */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale */
/* was negligent regarding the  design  or manufacture of the part. Freescale */
/* and the Freescale logo* are registered trademarks of Freescale Ltd.         */
/*****************************************************************************/


#include "sci_drv.h"
#include "AS1.h"


tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */

/******************************************************************************
Function Name	:	SCI_Config
Engineer		:	r32151
Date			:	05/03/02

Parameters		:	NONE
Returns			:	NONE
Notes			:	Configures SCI
******************************************************************************/
void
SCI_Config(tSCI *sci_ptr, unsigned int prescaler)
{

		/* set SCI1 baud rate */
	sci_ptr->SCIBD.Word = prescaler;
		/* set SCI1 control register 1 */
	sci_ptr->SCIC1.Byte = 0x00;
		/* enable SCI1 transmit */
	sci_ptr->SCIC2.Bits.TE = 1;
		/* enable SCI1 receive */
	sci_ptr->SCIC2.Bits.RE = 1;
}


/******************************************************************************
Function Name	:	DisplayString
Engineer		:	r58711
Date			:	14/02/02

Parameters		:	textString[]
Returns			:	NONE
Notes			:	Output text string as ASCII to SCI
******************************************************************************/
void DisplayString (unsigned char *textPointer)
{
		/* while not end of string */
	while(*textPointer != 0)
	{	
			/* write the character to the SCI interface */
		PutChar(*textPointer);
			/* increment to point at the next character in the string */
		textPointer++;
	}	
}

/******************************************************************************
Function Name	:	DisplayByte
Engineer		:	r58711
Date			:	14/02/02

Parameters		:	displayByte
Returns			:	NONE
Notes			:	Output variable SCI after conversion to ASCII
******************************************************************************/
void DisplayByte (unsigned char displayByte)
{
	unsigned char upperNibble, lowerNibble;
		/* Split data into nibbles for ASCII conversion */
	upperNibble = ((displayByte & 0xF0)>>4); 
	lowerNibble = (displayByte & 0x0F);
		/* Pass nibbles to SCI after passing for conversion to ASCII */
	PutChar(Number_2_ASCII(upperNibble));
	PutChar(Number_2_ASCII(lowerNibble));
}

/******************************************************************************
Function Name	:	PutChar
Engineer		:	r32151
Date			:	22/01/02

Parameters		:	char to be output to SCI1
Returns			:	NONE
Notes			:	
******************************************************************************/
void PutChar(char ch) 
{
		/* check SCI transmit data register is empty 
	while(TerminalPointer->SCIS1.Bits.TDRE == 0)
	{
	}	
	TerminalPointer->SCID.Byte = ch;	     

working AS1_SendChar () 
 while (SCI1S1_TDRE == 0);            // Is the transmitter empty?
  SCI1D = (byte)Chr;                   // Store char to the transmitter register 
  return ERR_OK;                       // OK 
*/
	byte TXERROR;
	TXERROR = ERR_TXFULL;
	
	while (TXERROR != ERR_OK){
	   TXERROR = AS1_SendChar(ch);
	}
}

/******************************************************************************
Function Name	:	GetChar
Engineer		:	r32151
Date			:	04/11/02

Parameters		:	char to be output to SCI
Returns			:	NONE
Notes			:	
******************************************************************************/
char GetChar(void) 
{
		/* check SCI1 receive data register is empty */
	while(TerminalPointer->SCIS1.Bits.RDRF == 0)
	{
	}	
	return(TerminalPointer->SCID.Byte);	
// 	return(AS1_RecvChar(ch));	
}

/******************************************************************************
Function Name	:	EchoGetChar
Engineer		:	r32151
Date			:	04/11/02

Parameters		:	char to be output to SCI
Returns			:	NONE
Notes			:	
******************************************************************************/
char EchoGetChar(void) 
{
		/* check SCI1 receive data register is empty */
	while(TerminalPointer->SCIS1.Bits.RDRF == 0)
	{
	}	
	PutChar(TerminalPointer->SCID.Byte);
	return(TerminalPointer->SCID.Byte);	
}

/******************************************************************************
Function Name	:	Number_2_ASCII
Engineer		:	r58711
Date			:	15.11.01

Parameters		:	Nibble of binary data (0000 to 1111) (unsigned char)
Returns			:	ASCII code for nibble (unsigned char)
*******************************************************************************/
unsigned char Number_2_ASCII(unsigned char Nibble)
{	
	/* If nibble is less than 9 (ie. a number) */
	if (Nibble <= 0x09) 
		/* Return the ASCII code for this number */
		return (Nibble + 0x30); 
	else
		/* Return the ASCII code for this letter */
		return (Nibble + 0x37); 
} 

/******************************************************************************
Function Name	:	ASCII_2_Number
Engineer		:	r58711
Date			:	15.11.01

Parameters		:	ASCII data byte (unsigned char)
Returns			:	numeric equivalent (unsigned char) of ASCII code 
*******************************************************************************/
unsigned char ASCII_2_Number(unsigned char ascii_char)
{
  byte number;	
	/* If character is 9 or less (ie. a number) */
	number = ascii_char - 0x30; 
	/* If character is greater than 9 (ie. hex number A,B,C,D,E,F) */
	if (number > 0x09) number -= 0x07;
	/* If chracter is greater than 9 and lower case (ie. hex number a,b,c,d,e,f) */
  if (number > 0x0F) number -= 0x20;	
  /* If charcter is non-numeric default to 0 */
  if (number > 0x0F) number = 0;
	return (number); 
} 

/******************************************************************************
Function Name	:	DisplayInt
Engineer		:	r32151
Date			:	04/09/02

Parameters		:	int count value to display
					unsigned char field width
Returns			:	NONE
Notes			:	Effectively perforns a number to string conversion and then
					outputs the string.
					if field width = 0 then the int is displayed left justified   
					with leading zeros supressed.
					if field width = 1-5 then lowest n digits are displayed
					with leading zeros.
					This routine does not check that the field size is valid.					
******************************************************************************/
void 
DisplayInt(unsigned int number, unsigned char field ) 
{
	char buf[6];
	char i = 5;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the int into ascii -> string buffer */
		buf[--i] = (char)(number % 10) + '0';
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (5-i)) && (field != 0))
		i = 5 - field;
				/* if field width is more than number of digits add leading zeros */
	if (field > (5-i))
	{
		while ((5-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}
	
/******************************************************************************
Function Name	:	DisplayLong
Engineer		:	r32151
Date			:	04/09/02

Parameters		:	long count value to display
					unsigned char field width
Returns			:	NONE
Notes			:	Direct replacement for NumberDisplay().

					Effectively perforns a number to string conversion and then
					outputs the string.
					if field width = 0 then the int is displayed left justified   
					with leading zeros supressed.
					if field width = 1-10 then lowest n digits are displayed
					with leading zeros.
					This routine does not check that the field size is valid.
					
					Due to the 32 bit math routines for handling long values
					code size and execution time is significantly larger that
					for DisplayInt.
******************************************************************************/
void 
DisplayLong(unsigned long number, unsigned char field ) 
{
	char buf[11];
	char i = 10;
	char length = 0;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the int into ascii -> string buffer */
		buf[--i] = (char)(number % 10) + '0';
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (10-i)) && (field != 0))
		i = 10 - field;
				/* if field width is more than number of digits add leading zeros */
	if (field > (10-i))
	{
		while ((10-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}	

