/** ###################################################################
**     Filename  : Events.C
**     Project   : PE_LL64_Quick_Start
**     Processor : MC9S08LL64C_LQFP80
**     Beantype  : Events
**     Version   : Driver 01.02
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 6/2/2009, 4:03 PM
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */


#include "Cpu.h"
#include "Events.h"
#include "Calendar.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
extern unsigned char channel_adc;
extern unsigned char state;
extern unsigned char new_channel;
extern bool LED1_ONOFF;      //LED control bits - all on 
extern bool LED2_ONOFF;
extern bool LED3_ONOFF;
extern bool LED4_ONOFF;

/*
** ===================================================================
**     Event       :  KB1_OnInterrupt (module Events)
**
**     From bean   :  KB1 [KBI]
**     Description :
**         This event is called when the active signal edge/level
**         occurs. This event is enabled only if Interrupt
**         service/events are enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void KB1_OnInterrupt(void)
{
  /* Write your code here ... */
    if (PTAD_PTAD7 == 0)
    {
    while(PTAD_PTAD7 ==0);
    while(PTAD_PTAD7 ==0);
    if(PTAD_PTAD7 ==1){
      
    if(state >=3){
    state =0 ;
    }else {
      state = state +1 ;
    }
    } 
    }
  
  
  //clear KBF
  KBISC_KBACK = 1;

}


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
/*
** ===================================================================
**     Interrupt handler : TOD_isr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
 ISR(TOD_isr)
{
  /* Write your interrupt code here ... */
  if (TODSC_SECF && TODSC_SECIE)
  {
    TODSC = (TODSC_SECIE_MASK | TODSC_SECF_MASK);
    vfnCalendar_UpdateDateAndTime();
    gu8TOD_Status |= (1<<TOD_SECONDS);
  }
  if (TODSC_MTCHF && TODSC_MTCHIE_MASK)
  {
    // could put temp measurement update on match??
    TODSC = ( TODSC_MTCHF_MASK |TODSC_MTCHIE_MASK | TODSC_MTCHEN_MASK );
    Calendar_RTC.Seconds = 60;
    vfnCalendar_UpdateDateAndTime();
    gu8TOD_Status |= (1<<TOD_MATCH);
  }
}
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
/*
** ===================================================================
**     Interrupt handler : IRQ_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
ISR(IRQ_ISR)
{
  /* Write your interrupt code here ... */

  if (PTCD_PTCD7 == 0)
    {
        while(PTCD_PTCD7 ==0);
        while(PTCD_PTCD7 ==0);
        if(PTCD_PTCD7 ==1){
      
        channel_adc = channel_adc+1;    
      
          //Single ended skip ADC channels 1 thru 3 Plus 8,9 and 0x0d through 0x19
      if (channel_adc == 0x01){
          channel_adc = 0x04 ;
      }
      if (channel_adc == 0x0D){           //skip reserved  channels 0D-12
          channel_adc = 0x13;            // now VREF0
      }
      if (channel_adc == 0x14){           //skip reserved  channels 
          channel_adc = 0x17;            // now VLCD
      }
      if (channel_adc == 0x19){           //skip reserved
          channel_adc = 0x1A;            // now temp sensor
      }
      if (channel_adc == 0x1C){           //skip reserved
          channel_adc = 0x1D;            // now VREFH
      }
      if (channel_adc == 0x1F){           //skip off
          channel_adc = 0x00;            // now channel 0
      }
    }
    }
  //clear IRQ Flag
  IRQSC_IRQACK = 1;
  new_channel = 1;

    }


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
/*
** ===================================================================
**     Interrupt handler : SCI_ERROR_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
ISR(SCI_ERROR_ISR)
{
  /* Write your interrupt code here ... */

}
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif


/*
** ===================================================================
**     Event       :  BUZZER_OnEnd (module Events)
**
**     From bean   :  BUZZER [PWM]
**     Description :
**         This event is called when the specified number of cycles has
**         been generated. (Only when the bean is enabled - <Enable>
**         and the events are enabled - <EnableEvent>). The event is
**         available only when the <Interrupt service/event> property
**         is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void BUZZER_OnEnd(void)
{
  /* Write your code here ... */
  // Clear CH0F flag
  TPM1C0SC &=0x7F;
 
  //Clear the 16-bit timer1 counter
  TPM1CNTH = 0x00;
}


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
/*
** ===================================================================
**     Interrupt handler : KBIOnInterrupt
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
ISR(KBIOnInterrupt)
{
  /* Write your interrupt code here ... */

}
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif


#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#endif
/*
** ===================================================================
**     Interrupt handler : KBI_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
ISR(KBI_ISR)
{
  /* Write your interrupt code here ... */
    if (PTAD_PTAD7 == 0)
    {
    while(PTAD_PTAD7 ==0);
    while(PTAD_PTAD7 ==0);
    if(PTAD_PTAD7 ==1){
      
    if(state >=3){
    state =0 ;
    }else {
      state = state +1 ;
    }
    } 
    }
  
  
  //clear KBF
  KBISC_KBACK = 1;

}
#ifdef ISR_IN_NONBANKED
#pragma CODE_SEG DEFAULT
#endif


/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.06 [04.26]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
