/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Thermostat_LCD.c
\brief      
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     
\version    0.1
\date       October/2008
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Thermostat_LCD.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/


/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
#ifdef __LOWEND_TSTAT__
const UINT8* DaysOfWeekLCDWaveForms[DAYS_OF_WEEK] = 
{
  (UINT8*)&_LCD_SUNDAY_WF,
  (UINT8*)&_LCD_MONDAY_WF,
  (UINT8*)&_LCD_TUESDAY_WF,
  (UINT8*)&_LCD_WEDNESDAY_WF,
  (UINT8*)&_LCD_THURSDAY_WF,
  (UINT8*)&_LCD_FRIDAY_WF,
  (UINT8*)&_LCD_SATURDAY_WF,
};

const UINT8 DaysOfWeekWaveformsBitNumbers[DAYS_OF_WEEK] = 
{
  (UINT8)_LCD_SUNDAY_BIT_NUMBER, 
  (UINT8)_LCD_MONDAY_BIT_NUMBER, 
  (UINT8)_LCD_TUESDAY_BIT_NUMBER, 
  (UINT8)_LCD_WEDNESDAY_BIT_NUMBER, 
  (UINT8)_LCD_THURSDAY_BIT_NUMBER, 
  (UINT8)_LCD_FRIDAY_BIT_NUMBER, 
  (UINT8)_LCD_SATURDAY_BIT_NUMBER
};
#endif

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/


void vfnThermostatLCD_Init(void)
{
  vfnLCD_Init();
  vfnLCD_All_Segments_OFF();
}

void vfnUpdateDayAndTime(RTC_Type* LocalRTC)
{
  UINT8 TemporalHour;
  UINT8 ASCII_Hour[HOUR_DIGITS];
  
  TemporalHour = LocalRTC->Hours;
  
  #ifdef __LOWEND_TSTAT__
    _LCD_PM_OFF;
    _LCD_AM_ON;
    if (TemporalHour >= 12)
    {
      
      TemporalHour -= 12;
      _LCD_PM_ON;
      _LCD_AM_OFF;
    }
    
    if (!TemporalHour)
    {
      TemporalHour = 12;
    }
  
    _LCD_ONE_OFF;
    if (TemporalHour >= 10)
    {
      _LCD_ONE_ON;
      TemporalHour -= 10;
    }
    ASCII_Hour[0] = TemporalHour + '0';
    Dec8bitsToASCIIBCD(LocalRTC->Minutes, &ASCII_Hour[1]);
  
  #else
    Dec8bitsToASCIIBCD(LocalRTC->Hours, &ASCII_Hour[0]);
    Dec8bitsToASCIIBCD(LocalRTC->Minutes, &ASCII_Hour[2]);
  #endif
  
  
  vfnLCD_Home();
  vfnLCD_Write_Msg(&ASCII_Hour[0], HOUR_DIGITS);
}

#ifdef __LOWEND_TSTAT__
  void vfnDisplayDayOfWeek(UINT8 DayOfWeek)
  {
    UINT8* WaveFormPointer;
    
    _LCD_SUNDAY_OFF;
    _LCD_MONDAY_OFF;
    _LCD_TUESDAY_OFF;
    _LCD_WEDNESDAY_OFF;
    _LCD_THURSDAY_OFF;
    _LCD_FRIDAY_OFF;
    _LCD_SATURDAY_OFF;
    
    if (DayOfWeek < DAYS_OF_WEEK)
    {
      /* Get the address of the waveform pointing to this Day of the Week*/
      WaveFormPointer = (UINT8*)DaysOfWeekLCDWaveForms[DayOfWeek];
      /* Turn on the bit of the DOW and the alternate message for the same day of the Week*/
      *WaveFormPointer  |= (1<<DaysOfWeekWaveformsBitNumbers[DayOfWeek]) | (1<<(DaysOfWeekWaveformsBitNumbers[DayOfWeek] + 4));
    }
  }
  
  
  void vfnBlinkDayOfWeek(UINT8 DayOfWeek)
  {
    UINT8* WaveFormPointer;
    
    if (DayOfWeek < DAYS_OF_WEEK)
    {
      WaveFormPointer = (UINT8*)DaysOfWeekLCDWaveForms[DayOfWeek];
      *WaveFormPointer &= ~(1<<(DaysOfWeekWaveformsBitNumbers[DayOfWeek] + 4));
    }
  }
  
#else
  void vfnDisplayDayOfWeek(UINT8 DayOfWeek)
  {

  }
#endif

void vfnDisplayBatteryLife(UINT16 BatteryLevel)
{
  _LCD_BATTERY_ON;
  _LCD_BAT1_ON;
  _LCD_BAT2_ON;
  _LCD_BAT3_ON;
  _LCD_BAT4_ON;
  
  if (BatteryLevel < BATT_4_LEVEL_INDICATOR)
  {
    _LCD_BAT1_OFF;
  }
  if (BatteryLevel < BATT_3_LEVEL_INDICATOR)
  {
    _LCD_BAT2_OFF;
  }
  if (BatteryLevel < BATT_2_LEVEL_INDICATOR)
  {
    _LCD_BAT3_OFF;
  }
  if (BatteryLevel < BATT_1_LEVEL_INDICATOR)
  {
    _LCD_BAT4_OFF;
  }
}

#ifdef __LOWEND_TSTAT__
  void vfnDisplayTemperature(UINT16 Temperature)
  {
    UINT8 Ascii_Temperature[2];
    UINT8 LocalTemp = (UINT8)(Temperature / 10);
    /* round up to next digit if decimal is greater than 0.5 */
    if ((Temperature % 10) > 5)
    {
      LocalTemp++;
    }
    Dec8bitsToASCIIBCD(LocalTemp, &Ascii_Temperature[0]);
    LCD_SET_CURSOR(LCD_TEMPERATURE_POS);
    vfnLCD_Write_Msg(&Ascii_Temperature[0], TEMPERATURE_DIGITS);
  }
  
#else
  void vfnDisplayTemperature(UINT16 Temperature)
  {
    UINT8 Ascii_Temperature[3];
    UINT8 LocalTemp = (UINT8)(Temperature / 10);
    UINT8 Modulo = Temperature % 10;
    /* round up to next digit if decimal is greater than 0.5 */
    Dec8bitsToASCIIBCD(LocalTemp, &Ascii_Temperature[0]);
    Ascii_Temperature[2] = Modulo + 0x30;
    
    LCD_SET_CURSOR(LCD_TEMPERATURE_POS);
    _LCD_DT8_ON;
    _LCD_COL4_ON;
    vfnLCD_Write_Msg(&Ascii_Temperature[0], TEMPERATURE_DIGITS);
  }
#endif
