/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: KBI_GB60.mcp
*
* Author : Laura Delgado
*          Gonzalo Delgado Huitron
* Department : RTAC Americas
*
* Description : This example illustrates the use of the KBI module for 
*               the MC9S08GB60 microcontroller. This example will show 
*               one application for the KBI module for the MC9S08GB60 
*               microcontroller.This project was made with the Device 
*               Initialization tool which sets the module, according 
*               to the user's needs. For this example, the KBI module 
*               is configured to comply with the following requirements:
*                       + Edge and level triggering sensitivity
*                       + PTA7 enabled as KBI pin7 with a pull-up resistor 
*                         enabled  
*                       + KBI interrupts enabled  
*                       + COP is disabled 
*                       + LED is controlled by PTB7 
*
*                            
* (Refer to AN3136 for more information about Device Initialization)
*
* History :   
* 10/08/2005  : Release (rgd04c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {
  MCU_init();
  EnableInterrupts; /* enable interrupts */
  /* include your code here */


  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave this function */
}
