/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: Stop_GB60.mcp
*
* Author : Gabriel Sanchez Barba
*          Gonzalo Delgado Huitron
* Department : RTAC Americas
*
* Description : This example illustrates the use of the Stop modes in 
*               the MC9S08GB60 microcontroller. This example will show
*               the 3 diferent Stop modes available.LEDs will flash 
*               according to the Stop modeThis project was made with 
*               the Device Initialization tool which sets the module, 
*               according to the user's needs. For this example, the 
*               Stop modes need to be configured to comply with the 
*               following requirements:
*                       + IRQ is enabled used to exit stop modes
*                       + Stop modes enabled  
*                       + LVD disabled  
*                       + COP is disabled 
*                       + LEDs are controlled by PTF0 and PTF1 
*
*                            
* (Refer to AN3136 for more information about Device Initialization)
*
* History :   
* 10/08/2005  : Release (rgd04c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

#define LED0    PTFD_PTFD0
#define LED1    PTFD_PTFD1


/*
 * Delay:      This function is for delay purposes only
 *
 * Parameters: None
 *
 * Return : None
 */

void Delay(void){
  unsigned int b;
  unsigned char a;
  for(a=0;a<0x03;a++)
  {
      for(b=0;b<0xFFFF;b++)
      {
        ;
      }
  }
}


void main(void) {
  MCU_init();
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

if(SPMSC2_PPDF==1){    /* If MCU recovered from Stop 2 mode*/
      SPMSC2 = 0x06;	 /* Clears PPDF flag and stop mode 1 enabled*/
      LED0 = 0;
      LED1 = 1;
      Delay();
      Delay();
      asm stop;        /*Stop instruction using Mode 1*/
  }
	LED0 = 0;
	LED1 = 0;
	Delay();
  PTFD = 0x0E;
  asm stop;					 /*Stop instruction using Mode 3*/
  SPMSC2=0x03;			 /*Stop mode 2 enabled*/
  LED0 = 1;
  LED1 = 0;
  Delay();  
  asm stop;					 /*Stop instruction using Mode 2*/
  for(;;){
      LED0 = ~LED0;  /*Blink leds*/
      LED1 = ~LED1;
      Delay();
  }
}
