/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: ADC_QG8.mcp
*
* Author : Andrs Barrilado
* Department : RTAC Americas
*
* Description : This example illustrates the use of the ADC module for the 
*               MC9S08QG8 microcontroller. This project was made with the 
*               Device Initialization tool which sets the module, according to 
*               the user's needs. For this example, the ADC module is configured
*               to trigger an interruption only if the conversion data is 
*               greater than 1/4 the source's voltage (which corresponds to approximately
*               0.825V if Vdd=3.3V). The example's configuration goes as follows:
*                       + Software conversion trigger selected, continuous conversion
*                         mode (to allow conversion even if the conversion complete flag
*                         is not set), 10-bit resolution sample, right alignment, low 
*                         powermode and internal bandgap buffer disabled )
*                       + 12.5khz as sampling frequency (obtained with a prescaler 
*                          value of 8, the bus clock selected as source, long 
*                          sample mode enabled).
*  											+ Compare function enabled - greater than mode, compare value 
*                          of 0x0FF considering that the example is in
*                          10-bit resolution mode).        
*                       + PTB3/ADP7 channel pin enabled and INITIALIZED as analog 
*                            input (IO control disabled).
*                       + Interrupt enabled - allows to display the most 
*                            significant pair of bits in two leds when a conversion
*                            is made. 
*                       + LEDS are controlled by PTB6 and PTB7,which must be 
*                            initialized as output pins as well. 
* 
*               According to this configuration, the Conversion complete 
*               interrupt will be triggered only when the conversion value is 
*               greater than the desired voltage, the scale of conversion is 
*               then rated from the compare value to Vdd i.e. Conversion data for the 
*               compare value (.825 V) will be zero. 
          
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was included in this 
*               project.
*
*               This example was explicitly made for the MC9S08QG8 microcontroller 
*               migrating may need some changes in the code.
*           
*               (Refer to AN3136 for more information about Device Initialization)
*
* History :   
* 10/08/2005  : Migration to CW 4.0(r12370c)
*/


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

  MCU_init();
  
  for(;;) { 

  }
   
}
