/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: IRQ_QG8.mcp
*
* Author : Laura Delgado
* Department : RTAC Americas
*
* Description : This example illustrates the use of the IRQ module for the 
*               MC9S08QG8 microcontroller. This project was made with the 
*               Device Initialization tool which sets the module according to 
*               the user's needs. For this example, the IRQ module is configured
*               to comply with the following requirements:
*                       + IRQ pin enable with a pull-up resistor.
*  											+ Configured to trigger an interruption when an
*                          edge-only event occurs.
*                       + Clear flag as part of initialization to avoid false
*                          interrupt requests.
*                       + During ISR (Interrupt Service Request) a LED is toggled
*                          every time an IRQ event is detected. The LED is con-
*                          trolled by PTB6 which is initialized  
*                            
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was not included in this 
*               project.
*
*               This example was explicitly made for the MC9S08QG8 microcontroller 
*               migrating may need some changes in the code.
*           
*               (Refer to AN3136 for more information about Device Initialization)
*
* History :   
* 10/08/2005  : Release (r12370c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

  MCU_init();		// includes IRQ initialization

  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave this function */
}
