/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: SCI_QG8.mcp
*
* Author : Laura Delgado
* Department : RTAC Americas
*
* Description : This example illustrates the use of the SCI module for the 
*               MC9S08QG8 microcontroller. This project was made with the 
*               Device Initialization tool which sets the module, according to 
*               the user's needs. For this example, the SCI module was made
*               to receive a byte serially and send it back serially
*               with a value of 1 added.
*               The example's configuration goes as follows:
*                       + 9600 bps baud rate (self clocked mode, with a baud
*                            rate divisor value of 26)
*                       + Loop mode disabeld, TxD output direction, 
*                           8-bit data format, StopMode disabled in wait mode, 
*                           idle line selected when wake up. 
*                       + No parity selected, break sending disabled, break 
*                           character lengh of 10 or 11 bits, Transmitter 
*                           output not inverted.
*                       + Receiver and transmitter pins enabled.
*                       + Receiver Interrupt enabled.
*
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was included in this 
*               project.           
*               (Refer to AN3136 for more information about Device Initialization)
*
*               NOTE: For better timing performance, trimming the internal clock 
*                     or using an external clock reference is recommended. 
*
* History :   
* 10/08/2005  : Migration to CW 4.0(r12370c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

  ICSTRM = *(unsigned char*far)0xFFBE;    /* Copy Factory Trim value */

  MCU_init();

  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave this function */
}
