/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: SPI_MASTER_QG8.mcp
*
* Author : Rogelio Gonzalez
* Department : RTAC Americas
*
* Description: 
*              
*   This project (SPI_MASTER_QG8.mcp) in addition to the project
*   SPI_SLAVE_QG8.mcp, illustrates a very simple use for the SPI
*   module. For this example, the master sends an increasing number 
*   to the slave. The Device Initialization tool was used to 
*   configure the required modules for this example. 
*               
*        + The SPI module was configured with the following parameters:
*           A 15.625 KHz SPI frequency accomplished with a Baud Rate 
*           prescaler value of 1, Baud Rate divisor value of 64, the 
*           mcu's clock settings have to be configured as well in 
*           the CPU module.  MASTER MODE selected, active-high polarity,
*           the First edge occurring at the middle of cycle, SPI serial 
*           data transfers starts with Most Significant bit,bidirectional 
*           mode disabled, Output enable in bidirectional mode disabled, 
*           SPI clocks operate in wait mode, SS1 used as GPIO, SPI Transmit 
*           Interrupt Disabled, SPI Receive and fault interrupt Enabled, 
*           SPI System Enabled.
*         
*       + The CPU module was configured with the following parameters: 
*           for the clock settings, FFL engaged mode, FLL reference 
*           oscillator frequency of 31.25Khz, bus frequency divider value 
*           of 8,  and FLL reference clock divider value of 1 where selected. 
*           The Reset Pin was enabled.
*         
*       + COP Watchdog is disabled for this example
*         
*       + PTB6 and PTB7 were enabled as outputs.
*
*   The initialization of the module is included in the automatically generated
*   MCUinit.c code, included in the project. 
*   
*   (Refer to AN3136 for more information about Device Initialization)
*
* History     :
* 27/07/2004  : Release. (A20639)
* 10/08/2005  : Migration to S08 (A19259)
* 10/08/2005  : Migration to CW 4.0 and Device Initialization(r12370c)
*/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"


void SPISendChar(unsigned char data);

unsigned char CurrentByte = 0;
unsigned int tmp;
  
void main(void) {

    MCU_init();

  for(;;) { 
  
     	for (tmp=0; tmp<35000; tmp++);	    /* Delay */
  
    	SPISendChar(CurrentByte);		/* Send next byte */
    	CurrentByte += 1;				/* Increase data to send */
 	    PTBD_PTBD6 = ~PTBD_PTBD6;  
  } 
}

void SPISendChar(unsigned char data) {
    while (!SPIS_SPTEF && !PTBD_PTBD5);	/* Wait until transmit buffer is empty */
    PTBD_PTBD5 = 0;	 /* Select slave */
  	SPID = data;			/* Start to send data */
}
