/*
** ###################################################################
**     THIS MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Project   : SPI_SLAVE_QG8
**     Processor : MC9S08QG8CDT
**     Version   : Bean 01.216, Driver 01.00, CPU db: 2.87.068
**     Datasheet : MC9S08QG8 Rev. 0.09 09/9/2005
**     Date/Time : 10/21/2005, 9:53 AM
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2005
**     UNIS, spol s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################
*/

#include <MC9S08QG8.h>                 /* I/O map */

unsigned char ReceivedByte;
/*
** ===================================================================
**     Method      :  MCU_init (bean MC9S08QG8_16)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9S08QG8_16 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /*  System clock initialization */
  /* SOPT1: COPE=0,COPT=0,STOPE=0,BKGDPE=1,RSTPE=1 */
  SOPT1 = 0x13;                                      
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=0,BGBE=0 */
  SPMSC1 = 0x18;                                      
  /* SPMSC2: PDF=0,PPDF=0,PPDACK=0,PDC=0,PPDC=0 */
  SPMSC2 = 0x00;                                      
  /* SPMSC3: LVDV=0,LVWV=0 */
  SPMSC3 &= (unsigned char)~0x30;                              
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=0,IREFSTEN=0 */
  ICSC1 = 0x04;                        /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=3,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  ICSC2 = 0xC0;                        /* Initialization of the ICS control register 2 */
  /* Common initialization of the write once registers */
  /* SOPT2: COPCLKS=1,IICPS=0,ACIC=0 */
  SOPT2 = 0x80;                                      

  /* Common initialization of the CPU registers */
  /* PTASE: PTASE5=1,PTASE4=1,PTASE3=1,PTASE2=1,PTASE1=1,PTASE0=1 */
  PTASE |= (unsigned char)0x3F;                               
  /* PTBSE: PTBSE7=1,PTBSE6=1,PTBSE5=1,PTBSE4=1,PTBSE3=1,PTBSE2=1,PTBSE1=1,PTBSE0=1 */
  PTBSE = 0xFF;                                      
  /* PTADS: PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  PTADS = 0x00;                                      
  /* PTBDS: PTBDS7=0,PTBDS6=0,PTBDS5=0,PTBDS4=0,PTBDS3=0,PTBDS2=0,PTBDS1=0,PTBDS0=0 */
  PTBDS = 0x00;                                      
  /* ### Init_SPI init code */
  /* SPIC1: SPIE=1,SPE=1,SPTIE=0,MSTR=0,CPOL=0,CPHA=0,SSOE=0,LSBFE=0 */
  SPIC1 = 0xC0;                                      
  /* SPIC2: MODFEN=0,BIDIROE=0,SPISWAI=0,SPC0=0 */
  SPIC2 = 0x00;                                      
  /* SPIBR: SPPR2=0,SPPR1=0,SPPR0=0,SPR2=1,SPR1=0,SPR0=1 */
  SPIBR = 0x05;                                      
  /* ### Init_GPIO init code */
  /* PTBD: PTBD7=0 */
  PTBD &= (unsigned char)~0x80;                              
  /* PTBPE: PTBPE7=0 */
  PTBPE &= (unsigned char)~0x80;                              
  /* PTBDD: PTBDD7=1 */
  PTBDD |= (unsigned char)0x80;                               
  /* ### Init_COP init code */
  SRS = 0xFF;                          /* Clear WatchDog counter */

  /* ### Init_GPIO init code */
  /* PTAD: PTAD3=0,PTAD2=0,PTAD1=0,PTAD0=0 */
  PTAD &= (unsigned char)~0x0F;                              
  /* PTAPE: PTAPE3=0,PTAPE2=0,PTAPE1=0,PTAPE0=0 */
  PTAPE &= (unsigned char)~0x0F;                              
  /* PTADD: PTADD3=1,PTADD2=1,PTADD1=1,PTADD0=1 */
  PTADD |= (unsigned char)0x0F;                               
  /* ### */
  asm CLI;                             /* Enable interrupts */
} /*MCU_init*/


/*
** ===================================================================
**     Interrupt handler : Vspi_isr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void Vspi_isr(void)
{
    unsigned char Temp;
                
    while (PTBD_PTBD2);   /* Once a byte is received, wait until the clock goes to its default state */
    Temp = SPIS_SPRF;     /* Read the SPI Status Register and, */
    ReceivedByte = SPID;  /* also read the SPI Data Register to acknowledge interrupt */

    ReceivedByte &= 0x0F;         
    PTAD &= 0xF0;
    PTAD |= ReceivedByte;        

    PTBD_PTBD7 = ~PTBD_PTBD7;


}
/* end of Vspi_isr */



/* Initialization of the CPU registers in FLASH */

/* NVPROT: FPS=0x7F,FPDIS=1 */
const volatile NVPROTSTR _NVPROT @0x0000FFBD = { 0xFF };

/* NVOPT: KEYEN=0,FNORED=1,SEC01=1,SEC00=0 */
const volatile NVOPTSTR _NVOPT @0x0000FFBF = { 0x7E };



extern void _Startup(void);

/* Interrupt vector table */
#define UNASSIGNED_ISR 0xFFFF          /* unassigned interrupt service routine */

void (* const _vect[])() @0xFFD0 = {   /* Interrupt vector table */
         UNASSIGNED_ISR,               /* Int.no.  0 Vrti (at FFD0)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  1 Reserved2 (at FFD2)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  2 Reserved3 (at FFD4)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  3 Vacmp (at FFD6)                 Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  4 Vadc (at FFD8)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  5 Vkeyboard (at FFDA)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  6 Viic (at FFDC)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  7 Vscitx (at FFDE)                Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  8 Vscirx (at FFE0)                Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  9 Vscierr (at FFE2)               Unassigned */
         Vspi_isr,                     /* Int.no. 10 Vspi (at FFE4)                  Used */
         UNASSIGNED_ISR,               /* Int.no. 11 Vmtim (at FFE6)                 Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 12 Reserved13 (at FFE8)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 13 Reserved14 (at FFEA)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 14 Reserved15 (at FFEC)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 15 Reserved16 (at FFEE)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 16 Vtpmovf (at FFF0)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 17 Vtpmch1 (at FFF2)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 18 Vtpmch0 (at FFF4)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 19 Reserved20 (at FFF6)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 20 Vlvd (at FFF8)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 21 Virq (at FFFA)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 22 Vswi (at FFFC)                  Unassigned */
         _Startup                      /* Int.no. 23 Vreset (at FFFE)                Reset vector */
 };




/* END */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.97 BETA [03.72]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
