/**
* Copyright (c) 2005, Freescale Semiconductor
* Freescale Willy Note
*
* File name : main.c
* Project name: TPM_IC_QG8.mcp
*
* Author : Laura Delgado
* Department : RTAC Americas
*
* Description : This example illustrates the input capture use of the timer 
*               module. This example makes use of the Device Initialization 
*               tool for the Timer module set up. 
*               
*               For this example, the TPM (Timer/PWM) module is configured
*               to comply with the following requirements:
*                       + Timer configured as input compare, on channel 1,  
*                          When a rising-edge event is captured through
*                          the channel-specific pin, the two most significant
*                          bits of the value of the timer at that time are 
*                          output through PTB6 and PTB7 using an interrupt-based
*                          approach. 
*
*                          Using a 4 MHz system-bus clock, the TPM is prescaled
*                          to overflow approximately every two seconds 
*                          (Prescaler = 7, Modulo = 7423).
*                                                                                     
*               The initialization of the module is the Device Initialization tool 
*               automatically generated MCUinit.c code, which was included in this 
*               project.
*
*               This example was explicitly made for the MC9S08QG8 microcontroller 
*               migrating may need some changes in the code.
*           
*								The channel input might need a pulldown resistor for stabilization.
*
*               (Refer to AN3136 for more information about Device Initialization)
* History :   
* 10/08/2005  : Release (r12370c)
*/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {

		 MCU_init();

  for(;;) {
  
       /* wait for input capture */
  
  } 
}
