/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Willy Note
 *
 * File name   : main.c
 * Project name: TPM_PWM_QG8.mpc
 *
 * Author      : Andres Barrilado
 * Department  : RTAC Americas
 *
 * Description : This is a descriptive example of the TPM module in the 
 *               MC98S08QG8 MCU configured to work as PWM.
 *               The example will toggle a LED with a varying duty cycle
 *               modified every TPM period. The configuration goes as follows:
 *                  +PWM period of 524ms (busclock as source clock, prescaler 
 *                      value of 32, module counter value of 0xFFFF).
 *                  +Reset duty cycle value of 0x0F00 (increments a value of 
 *                      0x1000 on every period)
 *                  +PWM is configured to be edge-aligned, output pin to be 
 *                      controlled by channel 1 and cleared when channel value 
 *                      is matched.
 *                  +Channel interrupt enabled. When serviced, the duty cycle 
 *                      will be incremented a value of 0x1000 on each interrupt 
 *                      request until the max value is reached , then 
 *                      the initial duty cycle value is restored.
 * 
 *                  +COP Watchdog disabled
 *
 *                  +Reset pin enabled
 *        
 *               The initialization of the module is the Device Initialization tool 
 *               automatically generated MCUinit.c code, which was included in this 
 *               project.
 *
 *               This example was explicitly made for the MC9S08QG8 microcontroller 
 *               migrating may need some changes in the code.
 *           
 *               (Refer to AN3136 for more information about Device Initialization)
 * History     :
 * 12/08/2005  : Release (r12368c)
 * 19/10/2005  : Migration to CW 4.0 (r12370c)
 */


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCUinit.h"

void main(void) {


		 MCU_init();

   for(;;) {
   
         /*Wait for timer interrupts*/

   } 
 
 }
