#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned int UINT16;

/* Uncomment one of the following definitions to configure the MCU clock in the desired mode */

//#define FEI       // Configure bus clock to run at 29MHz in FEI mode
//#define FEE		    // Configure bus clock to run at 2MHz in FEE mode
//#define FBI		    // Configure bus clock to run at low frequency in FBI mode
//#define FBE       // Configure bus clock to run at low frequency in FBE mode


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
  SOPT1 = 0x23;          /* Watchdog disable */  
  SCGC1 = 0x00;          /* All clock to peripherals are disable */
  SCGC2 = 0x00;          /* All clock to peripherals are disable */
}

void GPIO_Init(void) { 
  
  PTEDD = 0x01;          /* Configure PTE0 pin as output */
  PTED = 0x00;           /* Put 0 in PTE0 pin to turn the LED off */
}

  
void ICS_configuration(void) {
  
  #ifdef FEI
  ICSC1 = 0b00000100;   /* Output of FLL is selected and Internal Reference Selected */
  ICSC2 = 0b00000000;   /* Bus frequency divided by 1 */
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = (*(unsigned char*far)0xFFAE) | 0xA0;  /* Initialize ICSSC register from a non volatile memory */
                                                /* High range selected and Maximum frequency enabled */    
  #endif

  #ifdef FEE
  ICSC1 = 0b00000000;  /* Output of FLL is selected */
  ICSC2 = 0b10000111;  /* Divides slected clock by 4. External reference is selected */
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = (*(unsigned char*far)0xFFAE) | 0x00;  /* Initialize ICSSC register from a non volatile memory */
  #endif

  #ifdef FBE
  ICSC1 = 0b10111000;   /* External reference clock selected. External reference divided by 5 */     
  ICSC2 = 0b00000000;   /* Bus frequency divided by 1 */    
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = (*(unsigned char*far)0xFFAE) | 0x00;  /* Initialize ICSSC register from a non volatile memory */
  #endif
  
  #ifdef FBI
  ICSC1 = 0b01000000;   /* Internal reference clock is selected */     
  ICSC2 = 0b00000000;   /* Divides selected clock by 1 */     
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = (*(unsigned char*far)0xFFAE) | 0x00;  /* Initialize ICSSC register from a non volatile memory */
  #endif FBI
}

void Delay () {
  
  UINT16 i = 0;
  for (i; i<=60000; i++){
  }
}


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();
  GPIO_Init();
  ICS_configuration();
                 
  EnableInterrupts;  /* enable interrupts */

  for(;;) {
  
  PTED_PTED0 ^= 1;    /* Toggle PTE0 pin */
  Delay();            /* Delay function used to observe the LED toggle */
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}