/*********************************************************************/
/* Project Name: PWM.mcp                                             */
/* Source fle name: PWM.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: TPWM using PWM functionality                              */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: This project uses the PWM functionality of the TPWM  */
/* module. A PWM signal is generated and when the MCU is interrupt   */
/* the duty cycle is incremented in 1.                               */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */ 
 SCGC1 = 0x20;          /* Bus Clock to the TPWM1 module is enabled */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
 PTEDD = 0x01;          /* Configure PTE0 pin as output */
 PTED = 0x00;           /* Put 0's in port E */
}

void TPM_configuration (void) {
 TPM1MOD = 0x00FE;      /* Store 0x00FE value */
 TPM1C1SC = 0x68;       /* Channel 1 interrupt enable. PWM edge aligned */
 TPM1C1VH = 0x00;       /* TPM1C1V is a 16 bit register, for this example is only needed to store 0x0001 */
 TPM1C1VL = 0x01;       /* in this register at the beggining because the next value will be increased by 1 in the ISR */
 TPM1SC = 0x0F;         /* TPM Clock Source is the bus rate clock. This bus is divided by 128 */
}                     


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  TPM_configuration(); /* Function that initializes the TPWM module */

  EnableInterrupts; /* enable interrupts */

  for(;;) {
  PTED_PTED0 = PTBD_PTBD5;     /* PTB5 is the PWM output, so this output is display in PTE0 pin */
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    

void interrupt VectorNumber_Vtpm1ch1 TPM_ISR(void) {
  
 TPM1C1SC_CH1F;         /* Clear TPWM flags */
 TPM1C1SC_CH1F = 0;     /* Two-step flag acknowledgement */
 
 if (TPM1C1V <= 0x00F0){       /* If the maximum value of the duty cycle is not reached */
  TPM1C1V++;                   /* Increment de duty cycle by 1 */
  PTED_PTED0 = PTBD_PTBD5;     /* PTB5 is the PWM output, so this output is display in PTE0 pin */
 } 
 else {
  
 TPM1C1V = 0x0001;      /* Reset the value of duty cycle to 1 */
 }
}