/******************************************************************************
*                                             COPYRIGHT (c) MOTOROLA 2003   
* FILE NAME: pwm.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: PWM Source File
*                                                                           
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION: PWM Source File             
*                                                                           
* NOTE: 
*                                                                           
* AUTHOR: Eduardo Montanez    LOCATION: OHT     LAST EDIT DATE: 11/19/03  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe    	11/19/03	- Original coding 
*                                                                           
******************************************************************************/

#include "pwm.h"

/* Local function prototypes */

void pwm_init (void);

//***********************************************************************************
//
// Pulse-width Modulation Initialization routine 
//
//***********************************************************************************

void pwm_init (void)
{
	MODRR_MODRR0 = 1;		  // Re-route PWM Ch.0 to PTT[0]
	PWMPOL_PPOL0 = 1;		  // High -> Low polarity on Ch.0
	PWMCLK_PCLK0 = 0;		  // Clock A selected for Ch.0
	PWMPRCLK_PCKA = 3;		// No clock A prescaler for Ch.0
	PWMCAE_CAE0 = 0;		  // Left-aligned mode for Ch.0
	PWMPER0 = 0xFF;	    	// Ch.0 period (default ~ 2 KHz)
	PWMDTY0 = 0x00;		    //  Ch.0 duty cycle (default = 0 %)
}