/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : XSD1.c
**     CDE edition : Community
**     Project     : FRDM-24XSMBEVB_KL25z-Demo
**     Processor   : MKL25Z128VLK4
**     Component   : 36VeXtremeSwitch
**     Version     : Component 01.000, Driver 01.00, CPU db: 3.00.000
**     Repository  : My Components
**     Compiler    : GNU C Compiler
**     Date/Time   : 2017-02-28, 16:43, # CodeGen: 0
**     Abstract    :
**
**     Settings    :
**          Component Name                                 : XSD1
**          SPI_Device                                     : SPI_Device
**          Use 8-bit SPI communication                    : yes
**          Automatic watchdog toggling                    : no
**          Reset Pin control                              : Enabled
**            RSTB Link                                    : BitIO_LDD
**            RSTB Pin                                     : PTC12/TPM_CLKIN0
**          Devices On Daisy Chain                         : 1
**            Configuration for device0                    : Configuration_0
**          Configurations                                 : 1
**            Configuration_0                              : 1
**              Global Configuration                       : 
**                PWM channel 0                            : Enabled
**                PWM channel 1                            : Enabled
**                Parallel Mode                            : Disabled
**                Track & Hold current sensing             : Disabled
**                Watchdog                                 : Disabled
**                VDD failure detection                    : Disabled
**                Overvoltage protection                   : Enabled
**                CSNS Pin Function                        : Current Sensing on Channel 1
**              Output                                     : 2
**                HS0                                      : 
**                  Direct control                         : Disabled
**                  PWM duty                               : 64
**                  PWM Switch-on Delay                    : No Delay
**                  PWM clocksource                        : Internal
**                  External PWM Clock Divider             : 256
**                  Overcurrent profile                    : DC Motor
**                  Short circuit detection                : Disabled
**                  OpenLoad Detection in ON state         : Disabled
**                  OpenLoad Detection in OFF state        : Disabled
**                  Slew rate                              : Medium SR
**                  Random Current Offset                  : Add random offset
**                  Max Auto-Retry Count                   : Infinite retries
**                  Auto-Retry Period                      : tAUTO_10
**                  Auto-Retry Function                    : Disabled
**                  Low Current Threshold                  : I_OCL1
**                  Medium Current Threshold               : I_OCM1
**                  High Current Threshold                 : I_OCH1
**                  Threshold Activation Times             : tOCH1 and tOCM1_L
**                  Current Sense Ratio                    : high-current
**                HS1                                      : 
**                  Direct control                         : Enabled
**                  PWM duty                               : 256
**                  PWM Switch-on Delay                    : No Delay
**                  PWM clocksource                        : Internal
**                  External PWM Clock Divider             : 256
**                  Overcurrent profile                    : DC Motor
**                  Short circuit detection                : Disabled
**                  OpenLoad Detection in ON state         : Disabled
**                  OpenLoad Detection in OFF state        : Disabled
**                  Slew rate                              : Medium SR
**                  Random Current Offset                  : Add random offset
**                  Max Auto-Retry Count                   : Infinite retries
**                  Auto-Retry Period                      : tAUTO_10
**                  Auto-Retry Function                    : Disabled
**                  Low Current Threshold                  : I_OCL1
**                  Medium Current Threshold               : I_OCM1
**                  High Current Threshold                 : I_OCH1
**                  Threshold Activation Times             : tOCH1 and tOCM1_L
**                  Current Sense Ratio                    : high-current
**          Auto Initialization                            : yes
**     Contents    :
**         Init                - result XSD1_Init();
**         ReadRegister        - result XSD1_ReadRegister(uint8_t regAddr, uint16_t* regVal);
**         WriteRegister       - result XSD1_WriteRegister(uint8_t regAddr, uint16_t* regVal);
**         GetStatus           - result XSD1_GetStatus(uint16_t* statusData);
**         GetFaultInfo        - result XSD1_GetFaultInfo(uint16_t channel, uint16_t* faultInfo);
**         SetPWMDuty          - result XSD1_SetPWMDuty(uint8_t channel, uint16_t* dutyValues);
**         SetPWMState         - result XSD1_SetPWMState(uint8_t* channelStates);
**         FeedWatchdog        - result XSD1_FeedWatchdog();
**         ConfigureWatchdog   - result XSD1_ConfigureWatchdog(bool state, uint32_t deviceMask);
**         Diagnosis           - result XSD1_Diagnosis(uint16_t* diagData);
**         ConfigureMonitoring - result XSD1_ConfigureMonitoring(uint16_t* selection);
**
**     (c) Copyright Freescale 2014
** ###################################################################*/
/*!
** @file XSD1.c
** @version 01.00
** @brief
**
*/         
/*!
**  @addtogroup XSD1_module XSD1 module documentation
**  @{
*/         

/* MODULE XSD1. */

#include "XSD1.h"

/* buffers for SPI characters */
static uint8_t rxBuff[XSD1_COMM_LENGTH];
static uint8_t txBuff[XSD1_COMM_LENGTH];

/* internal function for reset toggle delay */
void XSD1_WaitReset(void) {
  volatile register int i = 0;
  /* aprox. 50us, every loop iteration takes approx. 10 cycles */
  for (;i < (CPU_CORE_CLK_HZ / 200000);i++) {}
}

/*
** ===================================================================
**     Method      :  XSD1_xs_Cal_bit_for_P (component 36VeXtremeSwitch)
**     @brief
**         Internal method for parity calculation needed by device SPI protocol.
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t p      - SPI data input
**         @return
**         bool            - Return P bit result
** ===================================================================
*/
uint8_t XSD1_xs_Cal_bit_for_P(uint16_t p)
{
  uint8_t ret;
  /* calculate parity for bits in p */
  for(ret=0; p > 0; p >>= 1) {
    ret ^= (p & 1);
  }
  return (ret);
}

/*
** ===================================================================
**     Method      :  XSD1_xs_write_register (component 36VeXtremeSwitch)
**     @brief
**         Writes value to the given register via SPI. The method waits
**         for completion of the operation. This is only for internal use.
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Register address
**         @param
**         uint16_t regVal - Value to be written
**         @return
**         bool            - Return true if the operation was successful
** ===================================================================
*/
bool XSD1_xs_write_register(uint8_t regAddr, uint16_t *regVal)
{
  uint16_t command = 0x0000U;
  uint16_t i = 0;
  uint16_t parity = 0;
  bool result;
  uint16_t buffer_pos;
  /* the order of input data is reverse that what is needed for daisy chain */
  /* first device needs to be last */
  buffer_pos = 2*(XSD1_DAISY_CHAIN_LENGTH - 1);
  /* process all data for the whole daisy chain */
  for(i=0; i<XSD1_DAISY_CHAIN_LENGTH; i++) {
    if (regVal[i] == DO_NOT_WRITE) {
      command = 0xFFFFU;
    } else {
      command = 0;
      /* insert address bit field (at bit 10) */
      command = (uint16_t) (regAddr & 0x0f)  << 10;
      /* place register value to be written (bits 0-8) */
      command = (uint16_t) command | (regVal[i] & 0x81FF);
      /* compute parity */
      parity = XSD1_xs_Cal_bit_for_P(command);
      /* add parity value */
      command = (uint16_t) (command | (parity & 1) << 14);
    }
    /* fill tx buffer     */
    txBuff[buffer_pos] = (uint8_t)(command >> 8);
    txBuff[buffer_pos + 1] = (uint8_t)command;
    buffer_pos -= 2;
  }
  /* select the device */
  SPI_Device1_Select();
  /* send and receive data */
  result = (SPI_Device1_TransferBlock(txBuff, rxBuff, XSD1_COMM_LENGTH, FALSE) == ERR_OK);
  /* unselect device */
  SPI_Device1_Unselect();
  return result;
}

/*
** ===================================================================
**     Method      :  XSD1_xs_read_register (component 36VeXtremeSwitch)
**     @brief
**         Reads value of the given register via SPI. This is only for internal use.
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Address of the register
**         @param
**         uint16_t regVal - Pointer to the variable for result
**         @return
**         bool            - Return true if the operation was successful
** ===================================================================
*/
bool XSD1_xs_read_register(uint8_t regAddr, uint16_t *regVal)
{
  uint16_t command = 0x00;
  uint16_t parity = 0;
  int i;
  bool result;
  uint16_t buffer_pos;
  /* shift bit 3 of the address (channel number) to the D13 position */
  command = (uint16_t) ((regAddr & 0x8) << 10) | (regAddr & 0x7);
  /* add address of the STATR register */
  command = (uint16_t) (command | ((XS_SI_STATR_0 & 0x7) << 10));
  /* calculate parity */
  parity = XSD1_xs_Cal_bit_for_P(command);
  /* put parity bit to D14 */
  command = (uint16_t) (command | ((parity & 0x1) << 14));
  /* fill tx buffer with read-command values, same for all devices */
  for(i = 0; i < XSD1_COMM_LENGTH; i++) {
    txBuff[i] = (uint8_t) (command >> 8);
    i++;
    txBuff[i] = (uint8_t) command;
  }
  /* select slave */
  SPI_Device1_Select();
  /* send and receive address byte */
  result = (SPI_Device1_TransferBlock(txBuff, rxBuff, XSD1_COMM_LENGTH, FALSE) == ERR_OK);
  /* toggle with CS pin */
  SPI_Device1_Unselect();
  SPI_Device1_Select();
  /* put empty characters into tx buffer, only reading will be performed */
  for(i = 0; i < XSD1_COMM_LENGTH; i++) {
    txBuff[i] = 0xFFU;
  }
  /* receive data (transmitted data are ignored) */
  result &= (SPI_Device1_TransferBlock(txBuff, rxBuff, XSD1_COMM_LENGTH, FALSE) == ERR_OK);
  SPI_Device1_Unselect();
  /* the order of input data is reverse than order in daisy chain, first device is last */
  buffer_pos = 2 * (XSD1_DAISY_CHAIN_LENGTH - 1);
  for(i = 0; i < XSD1_DAISY_CHAIN_LENGTH; i++) {
    /* write data to output array */
    regVal[i] = (((uint16_t) rxBuff[buffer_pos]) << 8) | rxBuff[buffer_pos + 1];
    buffer_pos -= 2;
  }
  return result;
}

/*
** ===================================================================
**     Method      :  XSD1_Init (component 36VeXtremeSwitch)
**     @brief
**         Initializes the device(s) according to the set properties. This 
**         method writes the data gathered from the component properties 
**         into registers via SPI. When auto initialization is enabled, 
**         this method will be called automatically within PE initialization 
**         function - PE_low_level_init(). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_Init()
{
  uint16_t temp[XSD1_DAISY_CHAIN_LENGTH];
  XSD1_result result = ES_ERR_OK;
  /* toggle RSTB pin */
  RSTBPin1_ClrVal(NULL);
  XSD1_WaitReset();
  RSTBPin1_SetVal(NULL);
  XSD1_WaitReset();
  if (!SPI_Device1_RequestBus()) {
    return FALSE;
  }
  temp[0] = 0x8000U;
  result |= XSD1_xs_write_register(XS_SI_STATR_0, temp);
  /* write initialization values to registers  */
  temp[0] = Configuration_0_OCR_0;
  result |= XSD1_xs_write_register(XS_SI_OCR_0, temp);
  temp[0] = Configuration_0_CONFR_0;
  result |= XSD1_xs_write_register(XS_SI_CONFR_0, temp);
  temp[0] = Configuration_0_RETRY_0;
  result |= XSD1_xs_write_register(XS_SI_RETRY_0, temp);
  temp[0] = Configuration_0_OCR_1;
  result |= XSD1_xs_write_register(XS_SI_OCR_1, temp);
  temp[0] = Configuration_0_CONFR_1;
  result |= XSD1_xs_write_register(XS_SI_CONFR_1, temp);
  temp[0] = Configuration_0_RETRY_1;
  result |= XSD1_xs_write_register(XS_SI_RETRY_1, temp);
  temp[0] = Configuration_0_GCR;
  result |= XSD1_xs_write_register(XS_SI_GCR, temp);
  SPI_Device1_ReleaseBus();
  /* set initial PWM duty values */
  temp[0] = 64;
  result |= XSD1_SetPWMDuty(0, temp);
  temp[0] = 256;
  result |= XSD1_SetPWMDuty(1, temp);
  return result;
}

/*
** ===================================================================
**     Method      :  XSD1_ReadRegister (component 36VeXtremeSwitch)
**     @brief
**         Reads value of the given register via SPI. This method allows 
**         the user to read content from a register of the device(s). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Address of the register, these address already 
**                           defined in MC06XSD200.h file in project. 
**         @param
**         uint16_t regVal - Pointer to the variable for resulting data. 
**                           If there are more devices in a daisy chain, 
**                           all devices are read at once. The size of the 
**                           array must match the length of the daisy-chain 
**                           configured in component. In case there is only 
**                           single device, the size is 1. 
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_ReadRegister(uint8_t regAddr, uint16_t *regVal)
{
  if(regVal == NULL)
    return ES_ERR_PARA;
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* write value */
  if(!XSD1_xs_read_register(regAddr, regVal)){
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_WriteRegister (component 36VeXtremeSwitch)
**     @brief
**         Writes value to the given register via SPI. This method allows 
**         the user to set a custom value to a register of the device(s). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Register address 
**         @param
**         uint16_t regVal - Pointer to the value(s) to be written. If there 
**                           are more devices in a daisy chain, all devices 
**                           are written. The size of the array must match 
**                           the length of the daisy chain configured in 
**                           component. In case there is only single device, 
**                           the size is 1. 
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_WriteRegister(uint8_t regAddr, uint16_t *regVal)
{
  if(regVal == NULL) {
    return ES_ERR_PARA;
  }
  /*  Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /*  write value */
  if(!XSD1_xs_write_register(regAddr, regVal)){
      SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /*  Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_GetStatus (component 36VeXtremeSwitch)
**     @brief
**         Returns current general status information. It can be used for 
**         quick check of devices. Current status of all devices on daisy 
**         chain will be stored in an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t statusData - Pointer to array that will be filled with the 
**                           status information. The size of the array must 
**                           match the length of the daisy chain configured 
**                           in component. In case there is only single 
**                           device, the size is 1. Each item of the array 
**                           will be a combination of these values: 
**                           ES_STATUS_OVERVOLTAGE - overvoltage fault 
**                           ES_STATUS_UNDERVOLTAGE - undervoltage fault 
**                           ES_STATUS_POR - power-on reset (POR) has occurred 
**                           ES_STATUS_FAULT0 - faults are detected on channel 
**                           0 
**                           ES_STATUS_FAULT1 - faults are detected on channel 
**                           1 
**                           ES_STATUS_AUTORETRY0 - auto-retry counter is 
**                           full on channel 0 
**                           ES_STATUS_AUTORETRY1 - auto-retry counter is 
**                           full on channel 1 
**                           ES_STATUS_OUT0 - indicate the status of channel 
**                           0 is ON:1  OFF:0 
**                           ES_STATUS_OUT1 - indicate the status of channel 
**                           1 is ON:1  OFF:0 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_GetStatus(uint16_t *statusData)
{
  uint16_t i;
  if(statusData == NULL)
    return ES_ERR_PARA;
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read register content and fill to buffer input */
  if (!XSD1_xs_read_register(XS_SO_STATR, statusData)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* clear unrelated bits */
  for(i=0;i<XSD1_DAISY_CHAIN_LENGTH;i++){
    statusData[i] &= ES_ALL_SO_DATA_BITS;
  }
  /* Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_GetFaultInfo (component 36VeXtremeSwitch)
**     @brief
**         Gets fault status information. It can be used to check failure 
**         details when fault happens. The fault information will be stored 
**         to an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t channel - The number of the channel that we request information 
**                           for. 
**         @param
**         uint16_t faultInfo - Pointer to array of uint16_t that will be filled 
**                           with the fault information. The size of the 
**                           array must match the length of the daisy chain 
**                           configured in component. In case there is only 
**                           single device, the size is 1. Each item of 
**                           the array will be a combination of these values: 
**                           ES_ERR_OC - overcurrent fault on channel 
**                           ES_ERR_SC - severe short-circuit 
**                           ES_ERR_OS - output shorted to VPWR 
**                           ES_ERR_OLOFF - open load in OFF state 
**                           ES_ERR_OLON - open load in ON state 
**                           ES_ERR_OTW - overtemperature 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_GetFaultInfo(uint16_t channel, uint16_t *faultInfo)
{
  uint8_t addr;
  uint16_t i;
  if(faultInfo == NULL)
    return ES_ERR_PARA;
  /* prepare register address acorrding to channel */
  if (channel == 0) {
    addr = XS_SO_FAULTR_0;
  } else if(channel == 1) {
    addr = XS_SO_FAULTR_1;
  } else {
    return ES_ERR_PARA;
  }
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read register content and fill to buffer input */
  if (!XSD1_xs_read_register(addr, faultInfo)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* clear unrelated bits */
  for(i=0;i<XSD1_DAISY_CHAIN_LENGTH;i++){
    faultInfo[i] &= ES_ALL_SO_DATA_BITS;
  }
  /* Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_SetPWMDuty (component 36VeXtremeSwitch)
**     @brief
**         Sets PWM duty for specified channel. Calling this method will 
**         set PWM output immediately (if PWM is enabled). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t channel - Output channel number 
**         @param
**         uint16_t dutyValues - Pointer to array that contains the PWM duty 
**                           values. The size of the array must match the 
**                           length of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. Input value must be in range 0 - 256 
**                           for the duty cycle 0 - 100 percent. 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_SetPWMDuty(uint8_t channel, uint16_t *dutyValues)
{
  int i;
  uint16_t temp_duty = 0x0000U;
  uint8_t addr;
  uint16_t tempVal[XSD1_DAISY_CHAIN_LENGTH];
  /* fill the daisy chain array */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
    /*  if duty is more than 0, bit ON_s is set   */
    if (dutyValues[i] > 0) {
      if(dutyValues[i] > 256U) {
        return ES_ERR_PARA;
      }
      temp_duty = (dutyValues[i] - 1) | ON_s_MASK;
    }
    else {
      temp_duty = 0x0000U;
    }
    tempVal[i] = temp_duty;
  }
  /* choose the register address acorrding to channel */
  if (channel == 0) {
    addr = XS_SI_PWMR_0;
  } else if(channel == 1) {
    addr = XS_SI_PWMR_1;
  } else {
    return ES_ERR_PARA;
  }
  /*  Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* write content to register */
  if(!XSD1_xs_write_register(addr, tempVal)){
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /*  Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_SetPWMState (component 36VeXtremeSwitch)
**     @brief
**         Enables or disables the PWM module. Activates the internal PWM 
**         module of both channels simultaneously according to the values 
**         of duty cycle and turn-on delays set previously. When the device 
**         works in PARALLEL mode, the linked channel cannot be set differently. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t channelStates - Pointer to array containing the PWM configuration 
**                           values. The size of the array must match the 
**                           length of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. When a channel is set PWM disabled, direct 
**                           input pins are applied. The values in array 
**                           can be: 
**                           ES_PWM_DISABLE_ALL - PWM module is disabled 
**                           for both channels 
**                           ES_PWM_ENABLE_CH0_ONLY - only set channel 0 
**                           enabled 
**                           ES_PWM_ENABLE_CH1_ONLY - only set channel 1 
**                           enabled 
**                           ES_PWM_ENABLE_ALL - PWM module is enabled for 
**                           both channels 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_SetPWMState(uint8_t *channelStates)
{
  int i;
  uint16_t regVal[XSD1_DAISY_CHAIN_LENGTH];
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read original content of register */
  if (!XSD1_xs_read_register(XS_SO_GCR, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* modify the related bits in buffer */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
    switch(channelStates[i]) {
      case ES_PWM_DISABLE_ALL:
        regVal[i] &= ~((PWM_en_0_MASK) | (PWM_en_1_MASK));
        break;
      case ES_PWM_ENABLE_CH0_ONLY:
        regVal[i] &= ~(PWM_en_1_MASK);
        regVal[i] |= (PWM_en_0_MASK);
        break;
      case ES_PWM_ENABLE_CH1_ONLY:
        regVal[i] |= (PWM_en_1_MASK);
        regVal[i] &= ~(PWM_en_0_MASK);
        break;
      case ES_PWM_ENABLE_ALL:
        regVal[i] |= ((PWM_en_0_MASK) | (PWM_en_1_MASK));
        break;
      default:
        SPI_Device1_ReleaseBus();
        return ES_ERR_PARA;
    }
  }
  /* write back to register */
  if(!XSD1_xs_write_register(XS_SI_GCR, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_FeedWatchdog (component 36VeXtremeSwitch)
**     @brief
**         Feeds the watchdog to avoid watchdog timeout in case the watchdog 
**         is enabled. When automatic watchdog toggling in disabled or no 
**         SPI data is sent (when watchdog toggling is enabled), please 
**         make sure this method is called at least twice during the watchdog 
**         timeout period (typ. 310 ms). In case the watchdog timeout happens, 
**         the device will enter fail-safe mode. Calling this method again 
**         will turn the device from fail-safe mode back to normal mode 
**         (all registers are reset). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_FeedWatchdog()
{
  uint16_t regVal[XSD1_DAISY_CHAIN_LENGTH];
  int i;
  /*  Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read original content of register */
  if (!XSD1_xs_read_register(XS_SO_STATR, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /*  invert WDIN bit */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
    regVal[i] = regVal[i] ^ 0x8000U;
    /*  clear rest of the bits */
    regVal[i] &= ~(0x7FFF);
  }
  /* write back to register */
  if(!XSD1_xs_write_register(XS_SI_STATR_0, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_ConfigureWatchdog (component 36VeXtremeSwitch)
**     @brief
**         Allows to configure (enable or disable) watchdog. After calling 
**         this method to enable watchdog, be sure SPI data are sent (when 
**         automatic watchdog toggling is enabled) or FeedWatchdog() is 
**         called (when watchdog toggling is disabled) periodically to avoid 
**         the watchdog timeout. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         bool state      - State of the watchdog. TRUE = watchdog enabled 
**         @param
**         uint32_t deviceMask - Each bit in this parameter represents one device 
**                           on the daisy chain. If a bit is '1' then the 
**                           configuration is applied to the device. '0' 
**                           means no change for the device with the index. 
**                           To apply value to all device, use the ES_ALL_DEVICES 
**                           constant. 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_ConfigureWatchdog(bool state, uint32_t deviceMask)
{
  uint16_t regVal[XSD1_DAISY_CHAIN_LENGTH];
  int i;
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read original content of register */
  if (!XSD1_xs_read_register(XS_SO_GCR , regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* modify the watchdog bit of each device words */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
    if(deviceMask & (1 << i)){
      if(state == FALSE)
        regVal[i] |=  (WD_dis_MASK);
      else
        regVal[i] &= ~(WD_dis_MASK);
    }
  }
  /* write back the modified content to register */
  if(!XSD1_xs_write_register(XS_SI_GCR, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* Release Bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_Diagnosis (component 36VeXtremeSwitch)
**     @brief
**         Runs a diagnosis routine. It will get channel configuration, 
**         product identification, current logic status of direct inputs, 
**         report of external clock failure (if external clock is enabled) 
**         and report of calibration failure. These information will be 
**         stored to an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t diagData - Pointer to array of uint16_t elements that 
**                           will be filled with the diagnosis information. 
**                           The size of the array must match the length 
**                           of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. Each element of the array will contain 
**                           a combination of these values: 
**                           ES_DIAG_CH1_DC_MOTOR - load is configured as 
**                           a DC motor type, if not present it's bulb type 
**                           ES_DIAG_CH0_DC_MOTOR - load is configured as 
**                           a DC motor type, if not present it's bulb type 
**                           ES_DIAG_PRODUCT_ID_BIT1 -  product identification 
**                           higher bit 
**                           ES_DIAG_PRODUCT_ID_BIT0 -  product identification 
**                           lower bit 
**                           ES_DIAG_IN1_ON - current logic state of the 
**                           direct input IN1 
**                           ES_DIAG_IN0_ON - current logic state of the 
**                           direct input IN0 
**                           ES_DIAG_CLOCKFAIL - external clock error occurred 
**                           ES_DIAG_CALIBFAIL - calibration failure occurred 
**                           during calibration of channel's internal clock 
**                           period 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_Diagnosis(uint16_t *diagData)
{
  int i;
  if(diagData == NULL)
    return FALSE;
  /* request SPI bus */
  if(!SPI_Device1_RequestBus())
    return ES_ERR_COMM;
  /* read diagnosis feedback content to buffer */
  if (!XSD1_xs_read_register(XS_SO_DIAGR, diagData)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* clear unrelated bits from SO data */
  for(i=0;i<XSD1_DAISY_CHAIN_LENGTH;i++){
    diagData[i] &= ES_ALL_SO_DATA_BITS;
  }
  /* release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/*
** ===================================================================
**     Method      :  XSD1_ConfigureMonitoring (component 36VeXtremeSwitch)
**     @brief
**         Sets current/temperature monitoring option of CSNS pin. If several 
**         eSwitch devices share the same CSNS pin and MCU ADC input pin, 
**         please make sure no more than 1 channel monitor is enabled at 
**         one time. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t selection - Pointer to array containing the monitoring 
**                           settings. The size of the array must match 
**                           the length of the daisy chain configured in 
**                           component. In case there is only single device, 
**                           the size is 1. Each item of the array contains 
**                           one of the following values: 
**                           ES_SENSE_DISABLE - sensing disabled 
**                           ES_CURRENTSENSE0  - current sensing for channel 
**                           0 (will not apply if highest overcurrent range 
**                           is not selected and the device works in Parallel 
**                           mode) 
**                           ES_CURRENTSENSE1  - current sensing for channel 
**                           1 
**                           ES_TEMPERATURESENSE - temperature sensing 
**                           ES_CURRENTSENSE_SUM - current sensing for summed 
**                           channels (this option will apply only if highest 
**                           overcurrent range is not selected and the device 
**                           works in Parallel mode) 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_ConfigureMonitoring(uint16_t *selection)
{
  uint16_t regVal[XSD1_DAISY_CHAIN_LENGTH];
  int i;
  /* Allocate bus */
  if(!SPI_Device1_RequestBus()) {
    return ES_ERR_COMM;
  }
  /* read original content of register */
  if (!XSD1_xs_read_register(XS_SO_GCR , regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* clear monitoring bits */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
      regVal[i] &= ~(CSNS0_en_MASK | CSNS1_en_MASK);
  }
  /* write to register */
  if (!XSD1_xs_write_register(XS_SI_GCR , regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* set monitoring bits */
  for(i=0 ; i<XSD1_DAISY_CHAIN_LENGTH ; i++) {
      regVal[i] |= (selection[i]  & (CSNS0_en_MASK | CSNS1_en_MASK));
  }
  /* write back modified content to register */
  if(!XSD1_xs_write_register(XS_SI_GCR, regVal)) {
    SPI_Device1_ReleaseBus();
    return ES_ERR_COMM;
  }
  /* Release bus */
  SPI_Device1_ReleaseBus();
  return ES_ERR_OK;
}

/* END XSD1. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
