/* ###################################################################
**     Filename    : main.c
**     Project     : XSF_KL25Z_Measurement
**     Processor   : MKL25Z128VLK4
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2015-06-23, 11:27, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.01
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "G4XS1.h"
#include "RSTBPin1.h"
#include "CLK1.h"
#include "SYNCPin1.h"
#include "SPI_Device1.h"
#include "CSpin1.h"
#include "TU1.h"
#include "SM1.h"
#include "AD1.h"
#include "TI1.h"
#include "TU2.h"
#include "CsIO1.h"
#include "IO1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* User includes (#include below this line is not maintained by Processor Expert) */
#include <stdio.h>

#define STRING_TO_PRINT Quantity[Counter++ % 3]
#define SET_QUANTITY_TO_MEASURE Quantity[(Counter + 1) % 3]

typedef uint16_t TMeasurementResult;

/* Variable set to TRUE by TimerInt component interrupt. If isInterrupt equals TRUE
 * the value of currently measured variable is printed to console. */
extern bool IsInterrupt;

/* IsSynchronized variable is set by OnSynchronization event of 32VeXtremeSwitch component. IsSynchronized
 * is set to TRUE if synchronization trigger of eXtreme Switch device is synchronized with PWM signal. */
extern bool IsSynchronized;

/* Helper variable to set next quantity to be measured. */
uint8_t Counter = 1;

char *ResultTable[] = {
                        "Channel 1 current: %d mA.\n",
                        "Channel 2 current: %d mA.\n",
                        "Channel 3 current: %d mA.\n",
                        "Channel 4 current: %d mA.\n",
                        "Channel 5 current: %d mA.\n",
                        "Battery voltage: %d mV.\n",
                        "Temperature: %d deg. of Celsius.\n"
};

G4XS1_TSenseMux Quantity[] = {smOUT1_CURRENT, smVBAT_MONITOR, smCTRL_DIE_TEMP};


/* This method prints measured value to console. */
void PrintMeasuredValue(G4XS1_TSenseMux WhatWasMeasured, uint16_t Value) {

    printf(ResultTable[WhatWasMeasured - 1], Value);
}

/* This method gets measured result and returns it in 16 bit unsigned integer format. The method also sets
 * trigger type. The trigger is different for temperature or voltage measurement and different for current measurement.
 * In order to get precise result either valid, trigger0 or trigger1/2 can be used. Please see datasheet for details. */
TMeasurementResult StartMeasurement() {

    TMeasurementResult Result;

    /* Clear flag. */
    IsSynchronized = FALSE;

    /* If current measurement is set, wait until synchronization trigger sets the flag so it is possible
     * to start current measurement. Note that it is a good practice to feed the watchdog even though the synchronization
     * takes less than is watchdog timeout. */
    /* removed, the trigger functionality depends on the load and duty cycle */
    /*
    while (IsSynchronized == FALSE) {
        G4XS1_FeedWatchdog();
    }
    */

    /* Start measurement and get measured value. */
    G4XS1_GetSenseValue(&Result);

    /* Prepare Extreme Switch device for next measurement. */
    G4XS1_ConfigureMonitoring(didxDEV1, SET_QUANTITY_TO_MEASURE, sstTRIG12);

    return Result;
}

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */

  /* Stores measurement result. */
  TMeasurementResult Result;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Set PWM duty of channel 1 (output 1). Output 1 was enabled in component so now it is possible
     * to directly drive the output by PWM. Second argument to the SetPWMDuty method is 0. This is
     * index of channel 1. Please notice hints in details column in Component Inspector to know indexes
     * of available channels.
     */
  G4XS1_SetPWMDuty(didxDEV1, 0, 220);

  while (1) {

      /* Every 2s periodic interrupt is raised to start
         * measurement and print the result to console.
         * Meanwhile the method FeedWatchdog is called. */
      while (!IsInterrupt) {
          G4XS1_FeedWatchdog();
      }

      /* Interrupt occurred - start measurement */
      Result = StartMeasurement();
      PrintMeasuredValue(STRING_TO_PRINT, Result);

      /* Clear interrupt flag. */
      IsInterrupt = FALSE;
  }

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
