/* ###################################################################
**     Filename    : main.c
**     Project     : XSF_KL25Z_SetPWMDuty
**     Processor   : MKL25Z128VLK4
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2015-06-22, 14:37, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.01
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "G4XS1.h"
#include "RSTBPin1.h"
#include "CLK1.h"
#include "SPI_Device1.h"
#include "CSpin1.h"
#include "TU1.h"
#include "SM1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* User includes (#include below this line is not maintained by Processor Expert) */
#include "FSL_Wait.h"

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */
  G4XS1_TError Error;
  bool Dir = TRUE;
  uint16_t Duty = 0;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  while (1) {
    Error = G4XS1_SetPWMDuty(0, 0, Duty); /* sets PWM duty for device 1 channel 1 (Note: indexed as 0) */
    if (Error != ERR_OK) {
      /* something went wrong */
    }
    Error = G4XS1_SetPWMDuty(0, 1, 256 - Duty); /* sets PWM duty for device 1 channel 3 (Note: indexed as 1) */
    if (Error != ERR_OK) {
	  /* something went wrong */
	}

    if (Dir == TRUE) { /* increment */
      Duty++;
      Dir = (Duty == 255) ? FALSE : TRUE;
    }
    else { /* decrement */
      Duty--;
      Dir = (Duty == 1) ? TRUE : FALSE;
    }

    G4XS1_FeedWatchdog();
    WaitMS(10);
  }

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
