/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_PWM_variable_phase
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-04-24, 17:39, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PWMA.h"
#include "FMSTR1.h"
#include "QSCI1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/********************************* GLOBAL VARIABLES *************************************/
Word16 w16Phase = 0;
Word16 w16PwmModulationIncrement = 0x000A;

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

  for(;;) 
  {
	  FMSTR_Poll();
  }
}

#pragma interrupt saveall
void PWM0_Reload_ISR()
{
	setReg16Bits(PWMA_SM0STS, PWMA_SM0STS_RF_MASK);	/* Clear interrupt request flag */
	
	setReg16(PWMA_SM1VAL2, PWMA_SM1VAL2+w16PwmModulationIncrement);
	
	if((Word16)PWMA_SM1VAL2>=0)
		{
		setReg16(PWMA_SM1VAL2, -2000); 
		}
	setReg16(PWMA_SM1VAL3, PWMA_SM1VAL2+2000);
	
	w16Phase = PWMA_SM1VAL2  - PWMA_SM0VAL2;
	
	/* Set LDOK LDOK0 for  update */
	setReg16Bits(PWMA_MCTRL,PWMA_MCTRL_LDOK0_MASK);
	
	FMSTR_Recorder();
}

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
