/* ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TmDt1.h
**     Project     : MC56F84000_TimeDate
**     Processor   : MC56F84789VLL
**     Component   : TimeDate
**     Version     : Component 02.111, Driver 02.06, CPU db: 3.50.001
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-05-05, 13:48, # CodeGen: 9
**     Abstract    :
**         This component "TimeDate" implements real time and date.
**         The component requires a periodic interrupt generator: timer
**         compare or reload register or timer-overflow interrupt
**         (of free running counter). User can select precision of
**         selected timer.
**         The component supports also alarm with event OnAlarm.
**     Settings    :
**         Timer name                  : PIT0 (16-bit)
**
**         Counter                     : PIT0_CNTR [E102]
**         Mode register               : PIT0_CTRL [E100]
**         Run register                : PIT0_CTRL [E100]
**         Prescaler                   : PIT0_CTRL [E100]
**         Compare register            : PIT0_MOD  [E101]
**
**         Interrupt name              : INT_PIT0_ROLLOVR
**         Interrupt enable reg.       : PIT0_CTRL [E100]
**         Priority                    : 1
**         User handling procedure     : TmDt1_OnAlarm
**         This event is called whenever the current time is equal
**         to alarm time
**
**         High speed mode
**             Prescaler               : divide-by-2
**             Clock                   : 50000000 Hz
**           Resolution of timer
**             Xtal ticks              : 8000
**             microseconds            : 1000
**             milliseconds            : 1
**             seconds (real)          : 0.001
**             Hz                      : 1000
**             kHz                     : 1
**
**         Initialization:
**              Timer                  : Enabled
**
**              Time                   : 0:0:0
**              Date                   : 1/1/2015
**     Contents    :
**         SetTime  - byte TmDt1_SetTime(byte Hour, byte Min, byte Sec, byte Sec100);
**         SetDate  - byte TmDt1_SetDate(word Year, byte Month, byte Day);
**         GetDate  - byte TmDt1_GetDate(DATEREC *Date);
**         SetAlarm - byte TmDt1_SetAlarm(byte Hour, byte Min, byte Sec, byte Sec100);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file TmDt1.h
** @version 02.06
** @brief
**         This component "TimeDate" implements real time and date.
**         The component requires a periodic interrupt generator: timer
**         compare or reload register or timer-overflow interrupt
**         (of free running counter). User can select precision of
**         selected timer.
**         The component supports also alarm with event OnAlarm.
*/         
/*!
**  @addtogroup TmDt1_module TmDt1 module documentation
**  @{
*/         

#ifndef __TmDt1
#define __TmDt1

/* MODULE TmDt1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"
#include <limits.h>


#ifndef __BWUserType_DATEREC
#define __BWUserType_DATEREC
  typedef struct { /* It contains actual year, month, and day description. */
    word Year; /* years (0x07CE - 0x0833) */
    byte Month; /* months (1 - 0x0C) */
    byte Day; /* days (0 - 0x06) */
  } DATEREC;
#endif

byte TmDt1_SetTime(byte Hour,byte Min,byte Sec,byte Sec100);
/*
** ===================================================================
**     Method      :  TmDt1_SetTime (component TimeDate)
**     Description :
**         This method sets a new actual time.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

byte TmDt1_SetDate(word Year,byte Month,byte Day);
/*
** ===================================================================
**     Method      :  TmDt1_SetDate (component TimeDate)
**     Description :
**         This method sets a new actual date. See limitations at the
**         page <General Info>.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Year            - Years (16-bit unsigned integer)
**         Month           - Months (8-bit unsigned integer)
**         Day             - Days (8-bit unsigned integer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

byte TmDt1_GetDate(DATEREC *Date);
/*
** ===================================================================
**     Method      :  TmDt1_GetDate (component TimeDate)
**     Description :
**         This method returns current date.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Date            - Pointer to the structure DATEREC. It
**                           contains actual year, month, and day
**                           description.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte TmDt1_SetAlarm(byte Hour,byte Min,byte Sec,byte Sec100);
/*
** ===================================================================
**     Method      :  TmDt1_SetAlarm (component TimeDate)
**     Description :
**         This method sets a new time of alarm. (only time, not date -
**         alarm event <OnAlarm> is called every 24 hours). Setting any
**         parameter out of its range disables alarm.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

void TmDt1_Init(void);
/*
** ===================================================================
**     Method      :  TmDt1_Init (component TimeDate)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void TmDt1_Interrupt(void);
/*
** ===================================================================
**     Method      :  TmDt1_Interrupt (component TimeDate)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END TmDt1. */

#endif /* ifndef __TmDt1 */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
