/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_TimeDate
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-05-04, 09:53, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "TEST1.h"
#include "TmDt1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/***************************************variable DEFINITIONS ******************************************/
extern DATEREC Date;
extern bool bAlarm;

void main(void)
{
	test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
    PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

    TEST1_testStart(&testRec, "Time And Date test");

  	Date.Year=2005;
  	Date.Month=12;
  	Date.Day=31;
  	
  	TEST1_testComment(&testRec, "wait 5s for alarm");
  	(void)TmDt1_SetAlarm(0,0,0,50);
  	do {} while (!bAlarm);
  	TEST1_testComment(&testRec, "alarm OK");
  	  
  	if (Date.Year != 2015) {
  	    TEST1_testFailed(&testRec, "year");
  	  } else {
  	    TEST1_testComment(&testRec, "year OK");
  	  }  
  	  
   	if (Date.Month != 1) {
  	    TEST1_testFailed(&testRec, "month");
  	  } else {
  	    TEST1_testComment(&testRec, "month OK");
  	  }  
  	 
  	if (Date.Day != 1) {
  	    TEST1_testFailed(&testRec, "day");
  	  } else {
  	    TEST1_testComment(&testRec, "day OK");
  	  }  

  	  TEST1_testEnd(&testRec);
}

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
